import zstandard as zstd
from tqdm import tqdm
import os

dctx = zstd.ZstdDecompressor()
file_names = [f"pile/train/{i:02d}.jsonl" for i in range(30)] + [
    f"pile/test.jsonl",
    f"pile/val.jsonl",
]

try:
    for file_name in tqdm(file_names):
        with open(file_name + ".zst", "rb") as ifh, open(file_name, "wb") as ofh:
            dctx.copy_stream(ifh, ofh, write_size=65536)

        if os.path.exists(file_name + ".zst"):
            os.remove(file_name + ".zst")
except:
    print("No zst files found.")
