import argparse
from src.launch_utils import generate_base_command, generate_run_commands
import src.merge_index as experiment


def main(args):
    cmd_list = []
    for i in range(30):
        flags = {
            "data_file": f"{i:02d}.jsonl",
            "output_dir": "indexes/roberta-large",
        }
        cmd = generate_base_command(experiment, flags=flags)
        cmd_list.append((cmd, []))

    generate_run_commands(
        cmd_list,
        num_cpus=args.num_cpus,
        num_gpus=args.num_gpus,
        mode="euler",
        num_hours=args.num_hours,
        promt=True,
        mem=args.mem,
        gpumem=args.gpumem,
    )


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--num-cpus", type=int, default=4)
    parser.add_argument("--num-gpus", type=int, default=1)
    parser.add_argument("--num-hours", type=int, default=12)
    parser.add_argument("--mem", type=int, default=16)
    parser.add_argument("--gpumem", type=int, default=24)
    args = parser.parse_args()
    main(args)
