import argparse
from src.launch_utils import generate_base_command, generate_run_commands
import src.sample_file as experiment


def main(args):
    flags = {
        "data_file": f"{2:02d}.jsonl",
        "nsamples": 100,
    }
    cmd = generate_base_command(experiment, flags=flags)

    generate_run_commands(
        [cmd],
        num_cpus=args.num_cpus,
        num_gpus=args.num_gpus,
        mode="euler",
        num_hours=args.num_hours,
        promt=True,
        mem=args.mem,
        gpumem=args.gpumem,
    )


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--num-cpus", type=int, default=4)
    parser.add_argument("--num-gpus", type=int, default=0)
    parser.add_argument("--num-hours", type=int, default=14)
    parser.add_argument("--mem", type=int, default=32)
    parser.add_argument("--gpumem", type=int, default=0)
    args = parser.parse_args()
    main(args)
