import os
import traceback
import faiss
import argparse


def main(args):
    index_path = os.path.join(args.output_dir, args.data_file)

    try:
        index = faiss.IndexFlatL2()
        for j in range(6):
            begin = j * 1000000
            end = (j + 1) * 1000000

            if j == 0:
                index = faiss.read_index(
                    index_path + "-" + str(begin) + "-" + str(end) + ".index"
                )
            else:
                index.merge_from(
                    faiss.read_index(
                        index_path + "-" + str(begin) + "-" + str(end) + ".index"
                    )
                )

        faiss.write_index(index, index_path + ".index")

    except Exception:
        print(f"File {args.data_file} something went wrong")
        print(traceback.format_exc())
        exit(-1)

    print(f"File {args.data_file} success!")


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--data_file", type=str, default="00.jsonl")
    parser.add_argument("--output_dir", type=str, default="indexes/roberta-large")
    args = parser.parse_args()
    main(args)
