from enum import Enum
import faiss


class Metric(Enum):
    L2 = "L2"
    IP = "IP"
    ABSIP = "ABSIP"


def str_to_metric(value: str) -> Metric:
    return Metric(value)


def get_index_class(metric: Metric):
    if metric == Metric.L2:
        return faiss.IndexFlatL2
    elif metric == Metric.IP or metric == Metric.ABSIP:
        return faiss.IndexFlatIP
    raise NotImplementedError(f"Metric `{metric}` not implemented")
