# Active Fine-Tuning

A library for automatic data selection in active fine-tuning of large neural networks.

## Installation

```
pip install activeft
```

## Usage Example

```python
from activeft.sift import Retriever

# Load embeddings
embeddings = np.random.rand(1000, 512)
query_embeddings = np.random.rand(1, 512)

index = faiss.IndexFlatIP(d)
index.add(embeddings)
retriever = Retriever(index)
indices = retriever.search(query_embeddings, N=10)
```

## Development

### CI checks

* The code is auto-formatted using `black .`.
* Static type checks can be run using `pyright`.
* Tests can be run using `pytest test`.

### Documentation

To start a local server hosting the documentation run ```pdoc ./activeft --math```.

### Publishing

1. update version number in `pyproject.toml` and `activeft/__init__.py`
2. build: `poetry build`
3. publish: `poetry publish`
4. push version update to GitHub
5. create new release on GitHub
