import argparse
# from launchers.utils import DATASETS, SOME_DATASETS, REST_DATASETS
from src.launch_utils import generate_base_command, generate_run_commands
import src.eval_tttlm as experiment

NAME = "Ablation_Study_Metrics"

MODEL = "gpt2"
# "gpt2-large",
# "google/gemma-2-2b",
# "microsoft/Phi-3-mini-4k-instruct"

RUN_CONFIG = {
    "gpt2": {
        "num-cpus": 4,
        "num-gpus": 1,
        "num-hours": 24,
        "mem": 20,
        "gpumem": 20,
    }
}

# NOTE: ABSIP metric is only supported with NearestNeighbor! (gives incorrect results otherwise, due to client-side selection not using the proper metric)

DATASETS = [
    "pile_arxiv",
    "pile_dm-mathematics",
    "pile_enron",
    "pile_europarl",
    "pile_freelaw",
    "pile_github",
    "pile_gutenberg",
    "pile_hackernews",
    "pile_nih-exporter",
    "pile_philpapers",
    "pile_pile-cc",
    "pile_pubmed-abstracts",
    "pile_pubmed-central",
    "pile_stackexchange",
    "pile_ubuntu-irc",
    "pile_uspto",
    "pile_wikipedia",
]
START_INDEX = 0

applicable_configs = {
    "k": [200],
    "lambda": [1.0],
    "algs": [
        "NearestNeighbour",
        "VTL",
    ],
    "datasets": [",".join(DATASETS)],
    "metric": [
        "ABSIP",
        "IP",
        "L2",
    ],
    "normalized": [True, False]
}


class Config:

    def __init__(self, model):
        if model in ["gpt2", "gpt2-large"]:
            self.max_length = 1024
            self.stride = 1024
            self.learning_rate = 2e-5
        elif model in ["gptneo"]:
            self.max_length = 2048
            self.stride = 2048
            self.learning_rate = 5e-6
        elif model in ["microsoft/Phi-3-mini-4k-instruct"]:
            # Use 4096 if GPU has enough memory
            self.max_length = 4096  # 4096
            self.stride = 1024  # 4096
            self.learning_rate = 2e-5
        else:
            raise AttributeError("Unsupported model")


def main(args):
    command_list = []
    for dataset in applicable_configs["datasets"]:
        for k in applicable_configs["k"]:
            for llambda in applicable_configs["lambda"]:
                for alg in applicable_configs["algs"]:
                    for metric in applicable_configs["metric"]:
                        for normalized in applicable_configs["normalized"]:
                            config = Config(MODEL)
                            flags = {
                                "name": NAME,
                                "seed": 1216,
                                "fraction_of_test_set": 0.01,
                                "num_neighbors": 50,
                                "k": k,
                                "gradient_steps": 1,
                                "batch_size": 1,
                                "llambda": llambda,
                                "acquisition_function": alg,
                                "dataset": dataset,
                                "model": MODEL,
                                "tokenizer": MODEL,
                                "embedding_model_checkpoint": "models/roberta-large-pile-lr2e-5-bs16-8gpu/checkpoint-1700000",
                                "max_length": config.max_length,
                                "stride": config.stride,
                                "learning_rate": config.learning_rate,
                                "address_path": "servers/metrics_addresses.txt",
                                "results_dir": "results/",
                                "metric": metric,
                                "normalized": normalized,
                                "start_index": START_INDEX,
                            }
                            cmd = generate_base_command(
                                experiment, flags=flags
                            )
                            command_list.append(cmd)

    generate_run_commands(
        command_list,
        num_cpus=args.num_cpus,
        num_gpus=args.num_gpus,
        mode="euler",
        num_hours=args.num_hours,
        promt=True,
        mem=args.mem,
        gpumem=args.gpumem,
        begin=args.begin,
    )


if __name__ == "__main__":
    run_config = RUN_CONFIG[MODEL]
    parser = argparse.ArgumentParser()
    parser.add_argument("--num-cpus", type=int, default=run_config["num-cpus"])
    parser.add_argument("--num-gpus", type=int, default=run_config["num-gpus"])
    parser.add_argument("--num-hours", type=int, default=run_config["num-hours"])
    parser.add_argument("--mem", type=int, default=run_config["mem"])
    parser.add_argument("--gpumem", type=int, default=run_config["gpumem"])
    parser.add_argument("--begin", type=str, default="now")
    args = parser.parse_args()
    main(args)
