import torch.nn as nn
import torch.nn.functional as F

class MLP(nn.Module):
    def __init__(self, num_features, hidden_features, num_classes):
        super().__init__()
        self.gc1 = nn.Linear(num_features, hidden_features)
        self.gc2 = nn.Linear(hidden_features, num_classes)

    def forward(self, x):
        x = F.relu(self.gc1(x))
        x = self.gc2(x)
        return x