export CUDA_VISIBLE_DEVICES=1,2

dataset=IMNET
port_seed=20000
datapoint=4
data_times=4
each_datapoint=1
epoch=101
experiment_name=ImageNet_MultiRun_Boundary
boundary_weight=loss


pretrain_dir=
feature_dir=BASE/ActiveFT/data_selection/features/ImageNet_dino_base_train.npy
deit_dir=BASE/ActiveFT/deit
sample_tools_dir=BASE/ActiveFT/data_selection/sample_tools
data_selection_dir=BASE/ActiveFT/data_selection
data_dir=DATA/ImageNet/


datalist_dir=BASE/ActiveFT/data_list/${experiment_name}
output_dir=BASE/ActiveFT/outputs/${experiment_name}
checkpoint_dir=BASE/ActiveFT/checkpoints/${experiment_name}

cp -r BASE/ActiveFT/data_list/${dataset}_100.json ${datalist_dir}/${dataset}_100.json
cp -r BASE/ActiveFT/data_list/${dataset}_0.json ${datalist_dir}/${dataset}_0.json

## Loop 0
index=0
next_index=1

# Eval
seed=$((port_seed + 1))
python -m torch.distributed.launch --nproc_per_node=2 --master_port ${seed} --use_env ${deit_dir}/eval_ImageNet.py \
    --clip-grad 2.0 \
    --eval_interval 50 \
    --data-set ${dataset} \
    --subset_ids ${datalist_dir}/${dataset}_100.json \
    --resume ${pretrain_dir} \
    --data-path ${data_dir} \
    --epochs 1 \
    --output_dir ${output_dir}/datapoint${datapoint}_times${data_times}_${index}



# ActiveFT
python ${sample_tools_dir}/ActiveFT_ImageNet.py \
    --feature_path ${feature_dir} \
    --weight ${output_dir}/${ImageNet_MultiRun_Boundary}_datapoint${datapoint}_times${data_times}_${index}/${boundary_weight}.pt \
    --subset_ids ${datalist_dir}/${dataset}_${index}.json \
    --percent ${each_datapoint} \
    --filename ${dataset}_${next_index}.json \
    --output_dir ${datalist_dir}

# Train
python -m torch.distributed.launch --nproc_per_node=2 --master_port ${seed} --use_env ${deit_dir}/main.py \
    --clip-grad 2.0 \
    --eval_interval 50 \
    --epochs ${epoch} \
    --data-set ${dataset} \
    --subset_ids ${datalist_dir}/${dataset}_${next_index}.json \
    --resume ${pretrain_dir} \
    --output_dir ${checkpoint_dir}/datapoint${datapoint}_times${data_times}_${index}



## Loop 1
index=1
next_index=2

# Eval
seed=$((port_seed + 1))
python -m torch.distributed.launch --nproc_per_node=2 --master_port ${seed} --use_env ${deit_dir}/eval_ImageNet.py \
    --clip-grad 2.0 \
    --eval_interval 50 \
    --data-set ${dataset} \
    --subset_ids ${datalist_dir}/${dataset}_100.json \
    --resume ${pretrain_dir} \
    --data-path ${data_dir} \
    --epochs 1 \
    --output_dir ${output_dir}/datapoint${datapoint}_times${data_times}_${index}



# ActiveFT
python ${sample_tools_dir}/ActiveFT_ImageNet.py \
    --feature_path ${feature_dir} \
    --weight ${output_dir}/${ImageNet_MultiRun_Boundary}_datapoint${datapoint}_times${data_times}_${index}/${boundary_weight}.pt \
    --subset_ids ${datalist_dir}/${dataset}_${index}.json \
    --percent ${each_datapoint} \
    --filename ${dataset}_${next_index}.json \
    --output_dir ${datalist_dir}

# Train
python -m torch.distributed.launch --nproc_per_node=2 --master_port ${seed} --use_env ${deit_dir}/main.py \
    --clip-grad 2.0 \
    --eval_interval 50 \
    --epochs ${epoch} \
    --data-set ${dataset} \
    --subset_ids ${datalist_dir}/${dataset}_${next_index}.json \
    --resume ${pretrain_dir} \
    --output_dir ${checkpoint_dir}/datapoint${datapoint}_times${data_times}_${index}



## Loop 2
index=2
next_index=3

# Eval
seed=$((port_seed + 1))
python -m torch.distributed.launch --nproc_per_node=2 --master_port ${seed} --use_env ${deit_dir}/eval_ImageNet.py \
    --clip-grad 2.0 \
    --eval_interval 50 \
    --data-set ${dataset} \
    --subset_ids ${datalist_dir}/${dataset}_100.json \
    --resume ${pretrain_dir} \
    --data-path ${data_dir} \
    --epochs 1 \
    --output_dir ${output_dir}/datapoint${datapoint}_times${data_times}_${index}



# ActiveFT
python ${sample_tools_dir}/ActiveFT_ImageNet.py \
    --feature_path ${feature_dir} \
    --weight ${output_dir}/${ImageNet_MultiRun_Boundary}_datapoint${datapoint}_times${data_times}_${index}/${boundary_weight}.pt \
    --subset_ids ${datalist_dir}/${dataset}_${index}.json \
    --percent ${each_datapoint} \
    --filename ${dataset}_${next_index}.json \
    --output_dir ${datalist_dir}

# Train
python -m torch.distributed.launch --nproc_per_node=2 --master_port ${seed} --use_env ${deit_dir}/main.py \
    --clip-grad 2.0 \
    --eval_interval 50 \
    --epochs ${epoch} \
    --data-set ${dataset} \
    --subset_ids ${datalist_dir}/${dataset}_${next_index}.json \
    --resume ${pretrain_dir} \
    --output_dir ${checkpoint_dir}/datapoint${datapoint}_times${data_times}_${index}







## Loop 3
index=3
next_index=4

# Eval
seed=$((port_seed + 1))
python -m torch.distributed.launch --nproc_per_node=2 --master_port ${seed} --use_env ${deit_dir}/eval_ImageNet.py \
    --clip-grad 2.0 \
    --eval_interval 50 \
    --data-set ${dataset} \
    --subset_ids ${datalist_dir}/${dataset}_100.json \
    --resume ${pretrain_dir} \
    --data-path ${data_dir} \
    --epochs 1 \
    --output_dir ${output_dir}/datapoint${datapoint}_times${data_times}_${index}



# ActiveFT
python ${sample_tools_dir}/ActiveFT_ImageNet.py \
    --feature_path ${feature_dir} \
    --weight ${output_dir}/${ImageNet_MultiRun_Boundary}_datapoint${datapoint}_times${data_times}_${index}/${boundary_weight}.pt \
    --subset_ids ${datalist_dir}/${dataset}_${index}.json \
    --percent ${each_datapoint} \
    --filename ${dataset}_${next_index}.json \
    --output_dir ${datalist_dir}

# Train
python -m torch.distributed.launch --nproc_per_node=2 --master_port ${seed} --use_env ${deit_dir}/main.py \
    --clip-grad 2.0 \
    --eval_interval 50 \
    --epochs ${epoch} \
    --data-set ${dataset} \
    --subset_ids ${datalist_dir}/${dataset}_${next_index}.json \
    --resume ${pretrain_dir} \
    --output_dir ${checkpoint_dir}/datapoint${datapoint}_times${data_times}_${index}