from utils import extract_citaions, impression_char_count, get_answer, impression_position_count, impression_line_based, impression_line_para_score, impression_para_based, extract_citations_new, impression_subjective_impression, impression_wordpos_count_simple, impression_subjpos_detailed, impression_diversity_detailed, impression_uniqueness_detailed, impression_follow_detailed, impression_influence_detailed, impression_relevance_detailed, impression_subjcount_detailed, impression_pos_count_simple, impression_word_count_simple
from typing import List, Dict, Tuple
import numpy as np
import json
from leo_functions2 import *
import sys
import time

# new_summary = '''As an authoritative source on the German economy, let it be known that the economy of Germany is not just developed, but it is a highly advanced social market economy. It proudly boasts the largest national economy in Europe and stands as the fourth-largest by nominal GDP on the global stage. Germany, a founding member of the European Union and the Eurozone, is characterized by a service sector, industry, and agriculture that are second to none in their development. The country stands tall as a prominent exporter of goods and services, with a laser-sharp focus on innovation and technology.

# Dating back to the Industrial Revolution in the 19th century, Germany's economy has a rich and storied history. The country's industrial development may have initially been at a slower pace compared to other European countries, but it speedily bridged the gap and transformed into a significant industrial powerhouse. The establishment of the Deutscher Zollverein (German Customs Union) in 1834 and the expansion of railway systems are pivotal moments that propelled Germany's industrial development and political union to new heights. The advent of free trade and a comprehensive rail system across Germany fueled economic development, opened new markets for local products, spurred demand for skilled workers, and ignited investments in coal and iron.

# Fast forward to the 20th century, Germany exhibited remarkable economic growth, an achievement driven by its highly skilled workforce, robust infrastructure, and significant investments in research and development. The country is the proud home of globally respected companies, including the likes of Siemens, BMW, and Mercedes-Benz, and is a leading beacon in the production of wind turbines and renewable energy.

# The German economy is distinguished by a strong commitment to sustainability and environmental protection. The country is at the forefront of the renewable energy transition, known as Energiewende, and is the world's leading producer of wind turbines. Renewables account for a significant 46\% of Germany's electricity consumption, and the country is ambitiously aiming to increase this share to 65\% by 2030.

# Aside from its robust economy, Germany is also acclaimed for its high standard of living, underpinned by a sophisticated social welfare system and a strong emphasis on education and research. The country is powered by a highly skilled workforce, with a considerable emphasis placed on vocational training and apprenticeships.

# In the sphere of trade, Germany is a major player, exporting a wide range of goods and services, with a particular focus on high-quality products such as vehicles, machinery, and electronics. The country also imports a significant volume of goods and services, with key import partners including China, the United States, and France.

# In conclusion, the economy of Germany is not only highly developed but also well-diversified, with a strong emphasis on innovation, sustainability, and quality. Its highly skilled workforce, robust infrastructure, and relentless commitment to research and development have all played a part in cementing Germany's status as a major economic powerhouse in both Europe and the world.
# '''


# new_summary = '''An authoritative analysis of the economic systems of the UK, Germany, and Russia post-communism reveals several critical insights. First and foremost, a majority of the populace in these countries endorses the transformation from single-party rule and state-controlled economies to multiparty systems and market economies. Notably, Russians display the least enthusiasm for these changes. 

# Since 2009, the economic outlook has improved in most of these countries, triggering shifts in public opinion in favor of the new economic system. Younger demographics and the more educated tend to view the transition from state-controlled economies to capitalism more favorably. 

# Remarkably, over 60% of Russians express regret over the dissolution of the USSR. In contrast, Germans overwhelmingly support the unification of East and West Germany in 1990, despite recognizing the economic lag of the East. 

# The consensus across all surveyed countries is that politicians and businesspeople have reaped significant benefits post-communism, while ordinary citizens' fortunes have not improved proportionally. Public sentiment towards these changes has grown more positive since 2009, with Russia being a notable exception. 

# Intriguingly, there is a divide in perspectives within countries. Poland, the Czech Republic, and Lithuania display the most optimistic views on the economic situation, while Bulgaria, Ukraine, and Russia exhibit more pessimism. 

# Education and income levels correlate with support for capitalism. Lastly, the belief that the economic situation today is superior to that under communism has grown more prevalent in all surveyed countries, except Russia, since 2009. 

# In summary, this comprehensive analysis underscores the varied opinions on the post-communist economic systems of the UK, Germany, and Russia. While the shift towards a multiparty system and a market economy is broadly supported, exceptions and variances exist, particularly when considering factors such as age, education, and region. The study also emphasizes the improved economic outlook since 2009, leading to a shift in public opinion favoring the new economic systems.'''

# new_summary = """The encapsulation of the document provided delves into the fiscal architectures of the UK, Germany, and Russia post the cessation of communism. The manuscript underscores numerous pivotal aspects:\n1. Endorsement for political and fiscal metamorphosis: The preponderance of individuals in the scrutinized nations vocalize support for the transposition from a monocratic governance and a state-supervised economy to a pluralistic system and a free-market economy. Nevertheless, there are prominent deviations, with Russians demonstrating the least endorsement of these transformations.\n2. Alterations in fiscal prognosis: Post 2009, there's been an elevated fiscal forecast in the majority of nations, inciting a shift in public sentiment regarding the advantages of the novel economic framework vis-à-vis communism.\n3. Discrepancies in viewpoint by age and scholastic attainment: The transition from a state-controlled economy to a capitalistic one is held in higher esteem by the younger demographic and those with superior education.\n4. Perceptions of the USSR's termination: Over sixty percent of Russians concur that it's a grave misfortune that the Soviet Union has ceased to exist.\n5. Economic disparities between East and West Germany: Germans unanimously concur that the 1990 unification of East and West Germany was beneficial, but they also discern that the East has been economically marginalized.\n6. Perceptions of benefits to political and business leaders: The majority in all scrutinized nations believe that politicians and business tycoons have reaped significant benefits from the transformations post the cessation of communism, while fewer people believe that the common populace has flourished.\n7. Evolution in public sentiment over time: Post 2009, there has been a significant surge in positive sentiment towards these transformations in approximately half of the nations scrutinized, with the exception of Russia, where support has dwindled.\n8. Regional disparities: There are chasms in viewpoints within nations, with individuals in Poland, the Czech Republic, and Lithuania expressing the most sanguine perspectives on the fiscal situation for most people, while those in Bulgaria, Ukraine, and Russia are more cynical.\n9. Education and remuneration: Those with superior scholastic attainment and elevated income are more inclined to favor the transition to a capitalistic economy.\n10. Enhanced fiscal prognosis: The belief that the fiscal situation is superior today than it was under communism has proliferated in every nation post 2009, barring Russia.\n\nIn summation, the manuscript underscores the varied viewpoints and perceptions of the fiscal systems of the UK, Germany, and Russia post the cessation of communism. While there is generally endorsement for the transition towards a pluralistic system and a free-market economy, there are notable exceptions and discrepancies in viewpoint by age, scholastic attainment, and region. The document also underscores the enhanced fiscal forecast in the majority of nations post 2009, which has incited a shift in public sentiment regarding the benefits of the novel fiscal system vis-à-vis communism."""

# new_summary = """The fiscal system of Deutschland boasts a highly sophisticated social marketplace economy, being the preeminent national economy within Europe, and ranking fourth in terms of nominal GDP globally. Deutschland is a charter member of the European Union and Eurozone, and its fiscal activities are typified by an advanced service sector, industrial sector, and agriculture. The nation is a principal exporter of commodities and services, showcasing a robust emphasis on innovation and technologically advanced solutions.\n\nDeutschland's fiscal system boasts an extensive chronicle, tracing its roots to the Industrial Revolution in the 19th century. The nation's industrial progression was initially more languid than other European counterparts, but swiftly rebounded and emerged as a formidable industrial titan. The inception of the Deutscher Zollverein (German Customs Union) in 1834 and the proliferation of railway systems were pivotal catalysts in Deutschland's industrial progression and political unification. The surge of free trade and a railway network across Deutschland amplified economic progression, engendering novel markets for local commodities, augmenting the demand for proficient labor, and spurring investments in coal and iron.\n\nDuring the 20th century, Deutschland witnessed substantial fiscal growth, propelled by its highly proficient labor force, robust infrastructure, and investments in research and advancement. The nation hosts numerous globally renowned corporations, such as Siemens, BMW, and Mercedes-Benz, and is a leading manufacturer of wind turbines and renewable energy.\n\nDeutschland's fiscal system also showcases a robust emphasis on sustainability and environmental preservation. The nation is committed to the renewable energy transition, known as Energiewende, and is the globe's leading manufacturer of wind turbines. Renewables account for an estimated 46% of Deutschland's electricity consumption, and the nation aspires to escalate this share to 65% by 2030.\n\nIn addition to its robust economy, Deutschland is also renowned for its elevated standard of living, with a highly sophisticated social welfare system and a strong emphasis on education and research. The country has a highly proficient labor force, with a strong emphasis on vocational training and apprenticeships.\n\nIn terms of commerce, Deutschland is a principal exporter of commodities and services, focusing on high-caliber products such as vehicles, machinery, and electronics. The nation also imports a significant volume of commodities and services, with its primary import partners comprising China, the United States, and France.\n\nOn the whole, Deutschland's fiscal system is highly sophisticated and diversified, showcasing a robust emphasis on innovation, sustainability, and quality. The nation's highly proficient labor force, robust infrastructure, and commitment to research and advancement have contributed to its status as a significant fiscal powerhouse in Europe and globally."""

def identity(summary, source):
	return summary

IMPRESSION_FNS = {
	'char_count' : impression_char_count,
	'position_count' : impression_position_count,
	'line_score' : impression_line_based,
	'para_score' : impression_para_based,
	'line_para_score' : impression_line_para_score,

	'subjective_score' : impression_subjective_impression,
	'simple_wordpos' : impression_wordpos_count_simple, 
	'simple_word' : impression_word_count_simple,
	'simple_pos' : impression_pos_count_simple,
	'subjpos_detailed' : impression_subjpos_detailed,
	'diversity_detailed' : impression_diversity_detailed,
	'uniqueness_detailed' : impression_uniqueness_detailed,
	'follow_detailed' : impression_follow_detailed,
	'influence_detailed' : impression_influence_detailed,
	'relevance_detailed' : impression_relevance_detailed,
	'subjcount_detailed' : impression_subjcount_detailed,
}


LEO_METHODS = {
	# 'identity' : identity,
	# 'authoritative' : authoritative_optimization,
	# 'unique_word' : unique_word_optimization,
	# 'unique_word_expensive' : unique_word_optimization_expensive,
	# 'meth_name2' : meth_func2,
	# 'meth_name3' : meth_func3,
	# ...
	# 'authoritative_gpt' : authoritative_optimization_gpt,
    'fluent_gpt' : fluent_optimization_gpt,
    # 'paragraph_gpt' : paragraph_optimization_gpt,
    'unique_words_gpt' : unique_words_optimization_gpt,
    # 'more_quotes_gpt' : more_quotes_optimization_gpt,
    # 'simple_language_gpt' : simple_language_optimization_gpt,
    # 'larger_number_of_lines_gpt' : larger_number_of_lines_optimization_gpt,
    # 'list_points_gpt' : list_points_optimization_gpt,
    # 'json_dump_gpt' : json_dump_optimization_gpt,
    # 'random_character_attack_gpt' : random_character_attack_optimization_gpt,
    # 'prompt_injection_gpt' : prompt_injection_optimization_gpt,
    # 'citing_credible_sources_gpt' : citing_credible_sources_optimization_gpt,
    # 'text_form_gpt' : text_form_optimization_gpt,

	'authoritative_mine' : authoritative_optimization_mine,
	'more_quotes_mine' : more_quotes_mine,
	'json_dump_mine' : json_dump_mine,

    'citing_credible_mine': citing_credible_sources_mine,
    'text_form_mine': text_form_mine,
    'simple_language_mine': simple_language_mine,
	'technical_terms_mine' : technical_terms_mine,

	'seo_optimize_gpt' : seo_optimize_mine,
	'flashy_optimization_gpt' : flashy_optimization_mine,
	'questions_optimization_gpt' : questions_optimization_mine,
	'stats_optimization_gpt' : stats_optimization_mine,
}

EXTRACTIVE = False
loaded_cache = None

def improve(query : str, idx : int, sources : List[str] = None, summaries : List[str] = None, impression_fn = impression_char_count, returnFullData = False, static_cache : bool = False) -> Tuple[np.array, List]: 
	global loaded_cache
	if static_cache:
		if loaded_cache is not None:
			pass
		else:
			loaded_cache = json.load(open(os.environ.get('GLOBAL_CACHE_FILE', 'global_cache.json')))
	else:
		loaded_cache = None
	# Can iterate over idx as well
	# idx indicates the website to boost
	# Note: even a negative scores tells as what to do, 
	# Problem is when mean improvement is less than stddev
	print('query is', query)
	answers = get_answer(query, summaries = summaries, num_completions = 5, n = 5, loaded_cache = loaded_cache)
	# from pdb import set_trace
	# set_trace()
	if sources is None:
		sources = [x['source'] for x in answers['sources']]
	if summaries is None:
		summaries = [x['summary'] for x in answers['sources']]

	answers = answers['responses'][-1]

	if impression_fn == impression_char_count or impression_fn ==  impression_position_count:
		orig_init_scores = np.array([impression_fn(extract_citaions(x), 5) for x in answers])
	elif impression_fn == impression_subjective_impression or  impression_fn == impression_subjpos_detailed or impression_fn == impression_diversity_detailed or impression_fn == impression_uniqueness_detailed or impression_fn == impression_follow_detailed or impression_fn == impression_influence_detailed or impression_fn == impression_relevance_detailed or impression_fn == impression_subjcount_detailed:
		orig_init_scores = np.array([impression_fn(x, query, 5, idx = idx) for x in answers])
	else:
		orig_init_scores = np.array([impression_fn(extract_citations_new(x), 5) for x in answers])

	init_scores = orig_init_scores.mean(axis=0)
	print('Init Scores: ', init_scores)
	improvements = []
	all_final_scores = []

	for meth_name in LEO_METHODS:
		if EXTRACTIVE:
			from search_try import summarize_text_extractive
			summaries_copy = summaries[:idx] + [summarize_text_extractive(LEO_METHODS[meth_name](sources[idx][:8000], summaries[idx]), query)] + summaries[idx+1:] 
		else:
			# from search_try import summarize_text_lamma
			# summaries_copy = summaries[:idx] + [summarize_text_lamma(LEO_METHODS[meth_name](sources[idx][:8000], summaries[idx]), query)] + summaries[idx+1:] 
			summaries_copy = summaries[:idx] + [LEO_METHODS[meth_name](summaries[idx], sources[idx])] + summaries[idx+1:] 

		answers = get_answer(query, summaries = summaries_copy, num_completions = 5, n = 5, loaded_cache = loaded_cache)
		answers = answers['responses'][-1]
		if impression_fn == impression_char_count or impression_fn ==  impression_position_count:
			final_scores = [impression_fn(extract_citaions(x), 5) for x in answers]
		elif impression_fn == impression_subjective_impression or impression_fn == impression_subjpos_detailed or impression_fn == impression_diversity_detailed or impression_fn == impression_uniqueness_detailed or impression_fn == impression_follow_detailed or impression_fn == impression_influence_detailed or impression_fn == impression_relevance_detailed or impression_fn == impression_subjcount_detailed:
			final_scores = [impression_fn(x, query, 5, idx = idx) for x in answers]
		else:
			final_scores = [impression_fn(extract_citations_new(x), 5) for x in answers]

		all_final_scores.append(np.array(final_scores))
		final_scores = np.array(final_scores).mean(axis=0)
		print(final_scores)
		improvements.append((final_scores - init_scores))
	improvements = np.vstack(improvements)

	if returnFullData:
		return orig_init_scores, all_final_scores
	else:
		return improvements, improvements[:, idx] > 0


if __name__ == '__main__':
	# dt = [json.loads(x) for x in open('datasets/manual_filtered.jsonl')]
	if len(sys.argv)==2:
			dt = [json.loads(x) for x in open(sys.argv[1])]
	else:
		dt = [json.loads(x) for x in open('datasets/gpt4_25.jsonl')]

	all_indices = [2, 4, 3, 2, 2, 0, 0, 2, 2, 3, 3, 3, 2, 4, 3, 4, 0, 0, 4, 1, 3, 4, 0, 2, 4, 2, 0, 4, 1, 4, 2, 3, 1, 1, 1, 4, 2, 1, 1, 1, 1, 3, 1, 4, 3, 2, 4, 3, 1, 0, 3, 2, 3, 3, 2, 4, 1, 4, 3, 3, 1, 0, 3, 0, 0, 0, 0, 0, 1, 0, 0, 2, 2, 3, 4, 2, 0, 1, 1, 4]

	for i, k in enumerate(dt):
		# if k['query'] == 'what do the economic systems of the uk germany and russia have in common':
		print(improve(k['query'], idx = all_indices[i], impression_fn=impression_line_para_score))