set -e
# setup
#if [ -d venv ]
#then
#    source venv/bin/activate
#else
#    python3 -m virtualenv venv
#    source venv/bin/activate
#    pip install -r requirements.txt
#fi

if [ ! -d policies ]
then
    mkdir policies
    mkdir models
    mkdir checkpoints
    mkdir pkls
    mkdir pkls/model_loss
    mkdir pkls/noisers
    mkdir pkls_git

    mkdir figs
    mkdir figs/model_loss
    mkdir figs/policy
    mkdir figs/policy/bar_plots
    mkdir figs/policy/bar_plots/no_obstacle
    mkdir figs/policy/bar_plots/car_road_obstacle_ditch
    mkdir figs/policy/bar_plots/car_ditch_obstacle_road
    mkdir figs/policy/bar_plots/car_ditch_obstacle_ditch
    mkdir figs/policy/bar_plots/car_road_obstacle_road
    mkdir figs/violin_plots
    mkdir figs/violin_plots/no_obstacle
    mkdir figs/violin_plots/car_road_obstacle_ditch
    mkdir figs/violin_plots/car_ditch_obstacle_road
    mkdir figs/violin_plots/car_ditch_obstacle_ditch
    mkdir figs/violin_plots/car_road_obstacle_road
    mkdir figs/returns
    mkdir figs/returns/no_obstacle
    mkdir figs/returns/car_road_obstacle_ditch
    mkdir figs/returns/car_ditch_obstacle_road
    mkdir figs/returns/car_ditch_obstacle_ditch
    mkdir figs/returns/car_road_obstacle_road
fi

if [ ! -d src/driving_gridworld ]
then
   cd src
   git clone https://github.com/AmiiThinks/driving_gridworld
   mv driving_gridworld tmp
   cd tmp
   mv driving_gridworld ..
   cd ..
   rm -rf tmp
   cd ..
fi

# run experiments
NUM_MODELS_TOTAL=2000
NUM_THREADS=$(( $(grep -c ^processor /proc/cpuinfo) ))
NUM_MODELS=$((NUM_MODELS_TOTAL / NUM_THREADS))

cd src
for (( i=1; i<=$NUM_THREADS; i++))
do
	python train_models.py --min-seed $(( (i-1)*NUM_MODELS )) --max-seed $(( i*NUM_MODELS )) & P1=$!
done
wait $P1
python obtain_policies.py --seed 0 --test t --k 1 & P1=$!
python obtain_policies.py --seed 0 --test t --k 2 & P2=$!
python obtain_policies.py --seed 0 --test t --k 4 & P3=$!
python obtain_policies.py --seed 0 --test t --k 5 & P4=$!
python obtain_policies.py --seed 0 --test t --k 10 & P5=$!
python obtain_policies.py --seed 0 --test t --k 20 & P6=$!
wait $P1 $P2 $P3 $P4 $P5 $P6
python obtain_policies.py --seed 1 --test t --k 1 & P1=$!
python obtain_policies.py --seed 1 --test t --k 2 & P2=$!
python obtain_policies.py --seed 1 --test t --k 4 & P3=$!
python obtain_policies.py --seed 1 --test t --k 5 & P4=$!
python obtain_policies.py --seed 1 --test t --k 10 & P5=$!
python obtain_policies.py --seed 1 --test t --k 20 & P6=$!
wait $P1 $P2 $P3 $P4 $P5 $P6
python obtain_policies.py --seed 2 --test t --k 1 & P1=$!
python obtain_policies.py --seed 2 --test t --k 2 & P2=$!
python obtain_policies.py --seed 2 --test t --k 4 & P3=$!
python obtain_policies.py --seed 2 --test t --k 5 & P4=$!
python obtain_policies.py --seed 2 --test t --k 10 & P5=$!
python obtain_policies.py --seed 2 --test t --k 20 & P6=$!
wait $P1 $P2 $P3 $P4 $P5 $P6
python obtain_policies.py --seed 3 --test t --k 1 & P1=$!
python obtain_policies.py --seed 3 --test t --k 2 & P2=$!
python obtain_policies.py --seed 3 --test t --k 4 & P3=$!
python obtain_policies.py --seed 3 --test t --k 5 & P4=$!
python obtain_policies.py --seed 3 --test t --k 10 & P5=$!
python obtain_policies.py --seed 3 --test t --k 20 & P6=$!
wait $P1 $P2 $P3 $P4 $P5 $P6
python obtain_policies.py --seed 4 --test t --k 1 & P1=$!
python obtain_policies.py --seed 4 --test t --k 2 & P2=$!
python obtain_policies.py --seed 4 --test t --k 4 & P3=$!
python obtain_policies.py --seed 4 --test t --k 5 & P4=$!
python obtain_policies.py --seed 4 --test t --k 10 & P5=$!
python obtain_policies.py --seed 4 --test t --k 20 & P6=$!
wait $P1 $P2 $P3 $P4 $P5 $P6
python run_policy_experiments.py --test t --percentile t & P1=$!
python run_policy_experiments.py --test t --gif t & P2=$!
python run_policy_experiments.py --test t --speed t --seed 0 1 2 3 4 & P3=$!
python run_policy_experiments.py --test t --average-return t --seed 0 1 2 3 4 & P=$!
python state_violins.py --no-obstacle t & P5=$!
python state_violins.py --car-road-obstacle-ditch t & P6=$!
python state_violins.py --car-ditch-obstacle-ditch t & P7=$!  python state_violins.py --car-road-obstacle-road t & P8=$!
python state_violins.py --car-ditch-obstacle-road t & P9=$!
python run_policy_experiments.py --test t --collision t --seed 0 1 2 3 4 & P10=$!
python run_policy_experiments.py --test t --distance t --seed 0 1 2 3 4 & P11=$!
python run_policy_experiments.py --test t --collision-speed t --seed 0 1 2 3 4 & P12=$!
python run_policy_experiments.py --test t --distance t --seed 0 1 2 3 4 & P13=$!
python run_policy_experiments.py --test t --collision-given-speed t --seed 0 1 2 3 4 & P14=$!
python run_policy_experiments.py --test t --speed-given-collision t --seed 0 1 2 3 4 & P15=$!
wait $P1 $P2 $P3 $P4 $P5 $P6 $P7 $P8 $P9 $P10 $P11
cd ..

# generate results in presentation form
cd results
pdflatex state_violin.tex
