
# Project Setup: EGeNet

This document provides instructions to set up the environment for running the EGeNet project, including installation, sanity checks, synthetic experiments, and chemical property prediction experiments.

### Step 1: Run the following commands to set up the environment, install the required packages, and run the necessary experiments:

```bash
# Create Conda environment with Python 3.11
conda create --name egenet -c conda-forge python=3.11

# Activate the environment
conda activate egenet

# Install PyTorch with CUDA 11.8
pip3 install torch torchvision torchaudio --index-url https://download.pytorch.org/whl/cu118

# Install additional dependencies
pip install torch_geometric
pip install pytorch-lightning
pip install easydict
pip install pandas
pip install rdkit
cd E-GenNet
# Sanity check for the model
python sanity_check.py

# Run synthetic experiments
python k_chain_exps.py

# Chemical property prediction experiments

# Download the Kraken, Drugs, and BDE datasets from
# https://github.com/SXKDZ/MARCEL and place them in the /data directory

# Example run for A10 users using one GPU and 24GB
python chemical_property_exps.py --dataset_name Kraken --task B5 --batch_size 5

# Example run for A40 users using one GPU and 48GB
python chemical_property_exps.py --dataset_name Kraken --task B5

# Chemical Properties Information:
# Options for --dataset_name: Drugs, Kraken, BDE
# Options for --task:
#   Drugs: ip, ea, chi
#   Kraken: B5, L, burB5, burL
#   BDE: Binding Energy
```

## Notes

- Make sure your machine supports CUDA 11.8 for optimal performance with PyTorch.
- If you encounter any issues with installation or dataset download, refer to the official documentation for each package or dataset repository.
