import torch


def tensor2numpy(x):
    if isinstance(x, torch.Tensor):
        return x.detach().to('cpu').numpy()
    elif isinstance(x, list):
        return [tensor2numpy(a) for a in x]
    elif isinstance(x, dict):
        return {k: tensor2numpy(v) for k, v in x.items()}
