# Accelerated Training of Physics Informed Neural Networks (PINNs) using Meshless Discretizations

The supplementary material contains the [``appendix``](appendix.pdf) of the paper and the code for running and replicating our experiments as well as generate the dataset that we have used.

## Requirements

To run the Matlab code in the [``MatlabSolver/``](MatlabSolver/) folder, a working Matlab account is required. For running the code for vanilla-PINNs and DT-PINNs, the following Python libraries are required:

1. numpy
2. matplotlib
3. json
4. scipy
5. cupy
6. torch

We provide a [``requirements.txt``](requirements.txt) file that can be used to install the libraries with pip:

```bash
>> pip install -r requirements.txt
```


## Dataset
We provide the Matlab code in [``MatlabSolver/``](MatlabSolver/) to generate the dataset for linear and nonlinear Poisson equations, and the heat equation.

### Poisson equation
To generate the datset for the Poisson equation, please use the [``GenSCAIMats.m``](MatlabSolver/GenSCAIMats.m) file. Inside it, change the ``nonlinear`` variable value to 0 for linear and 1 for nonlinear. Running this file automatically makes the corresponding ``data/`` (or ``nonlinear_data`` in case of nonlinear Poisson) in the ``supplementary`` folder.

### Heat equation
For the heat equation, use the [``GenerateVectorsTimeDependent.m``](MatlabSolver/GenerateVectorsTimeDependent.m) file. This file will add the three heat equation relevant vectors; ``u_heat.mat``, ``f_heat.mat``, and ``g_heat.mat`` in the ``data/`` folder in all subfolders for size 828.

## PINN code
We provide the Python code in [``src/``](src/) for vanilla-PINN and DT-PINN for all experiments: linear and nonlinear Poisson, the heat equation, and the effect of depth experiment. While the names of the code modules are self-explanatory, we clarify some of them below:

1. [``dtpinn_cupy_fp32.py``](src/dtpinn_cupy_fp32.py): Corresponds fo fp32 DT-PINN for linear Poisson equation.
2. [``dtpinn_cupy_fp64.py``](src/dtpinn_cupy_fp64.py): Corresponds fo fp64 DT-PINN for linear Poisson equation.
3. [``dtpinn_cupy_fp64_nonlinear.py``](src/dtpinn_cupy_fp64_nonlinear.py): Corresponds fo fp64 DT-PINN for nonlinear Poisson equation.
4. [``heat_dtpinn_cupy.py``](src/heat_dtpinn_cupy.py): Corresponds fo fp64 DT-PINN for the heat equation.

The vanilla-PINN code files [``vanilla.py``](src/vanilla.py), [``vanilla_heat.py``](src/vanilla_heat.py), and [``vanilla_nonlinear.py``](src/vanilla_nonlinear.py) correspond to the linear Poisson, heat equation, and nonlinear Poisson respectively.

For all PINN code, one can change the learning rate, floating point precision, training set size, order (for DT-PINN), network depth, and activation function directly in the code files. We share the code to contain the hyperparameters we have used throughout our experiments. The files automatically save the results in a descriptive folder name that can later be used for making plots.

## Plots
Lastly, we also share a script [``plotting.py``](src/plotting.py) for making the plots from the paper for any of the generated results. Since usually the plots were made to compare DT-PINNs and vanilla-PINNs, the file contains two empty variables ``discrete_results_folder`` and ``vanilla_results_folder`` that are to be filled with the folders of the results. The different plots required can be chosen by uncommenting the function calls from the bottom of the file.
