#!/usr/bin/env bash

CONFIG=$1
CHECKPOINT=$2
GPUS=$3
DIR=$4
PORT=${5:-29503}
NNODES=${NNODES:-1}
NODE_RANK=${NODE_RANK:-0}
MASTER_ADDR=${MASTER_ADDR:-"127.0.0.1"}

mkdir -p $DIR
log=$DIR/$(basename ${CHECKPOINT%.*})__$(date "+%Y-%m-%d_%H-%M-%S").log

PYTHONPATH="$(dirname $0)/..":$PYTHONPATH \
python -m torch.distributed.launch \
    --nnodes=$NNODES \
    --node_rank=$NODE_RANK \
    --master_addr=$MASTER_ADDR \
    --use_env \
    --nproc_per_node=$GPUS \
    --master_port=$PORT \
    $(dirname "$0")/test.py \
    $CONFIG \
    $CHECKPOINT \
    --launcher=pytorch \
    --eval=bbox \
    ${@:6} 2>&1 | tee $log