#!/usr/bin/env bash

CONFIG=$1
GPUS=$2
PORT=${3:-29500}
NNODES=${NNODES:-1}
NODE_RANK=${NODE_RANK:-0}
MASTER_ADDR=${MASTER_ADDR:-"127.0.0.1"}

work_dir="work_dirs/$(basename $(dirname $CONFIG))/$(basename ${CONFIG%.*})/$(date "+%Y-%m-%d_%H-%M-%S")"
mkdir -p $work_dir
log=$work_dir/err.log

PYTHONPATH="$(dirname $0)/..":$PYTHONPATH \
python -m torch.distributed.launch \
    --nnodes=$NNODES \
    --node_rank=$NODE_RANK \
    --master_addr=$MASTER_ADDR \
    --use_env \
    --nproc_per_node=$GPUS \
    --master_port=$PORT \
    $(dirname "$0")/train.py \
    $CONFIG \
    --seed 0 \
    --work-dir=$work_dir \
    --launcher=pytorch ${@:4} 2>&1 | tee $log