from scipy.spatial import distance

import pandas as pd


df = pd.read_csv('./data/country_and_group.csv', sep='\t')
country_list = df['Country'].tolist()

albania = df[df['Country'] == 'Albania']
albania = list(albania.values)[0]
albania = list(albania[-10:])

france = df[df['Country'] == 'France']
france = list(france.values)[0]
france = list(france[-10:])

group19 = df[df['Country'] == 'Group_19']
group19 = list(group19.values)[0]
group19 = list(group19[-10:])

data = pd.DataFrame(columns=['Country', 'Albania', 'France', 'Group_19'])

for country in country_list:
    if country == 'Albania' or country == 'France' or country == 'Group_19':
        continue
    else:
        row = df[df['Country'] == country]
        row = list(row.values)[0]
        row = list(row[-10:])

        albania_distance = distance.jensenshannon(albania, row)
        france_distance = distance.jensenshannon(france, row)
        group19_distance = distance.jensenshannon(group19, row)

        data.loc[len(data)] = [country, albania_distance, france_distance, group19_distance]

data.to_csv('./data/country_distance.csv', index=False)