import pandas as pd
import os



sample_df = pd.read_csv('./data/valueEval_10_sex_content_banned.csv', sep='\t')

train_df = sample_df.sample(frac=0.8, random_state=42)
test_val_df = sample_df.drop(train_df.index)
val_df = test_val_df.sample(frac=0.5, random_state=42)
test_df = test_val_df.drop(val_df.index)

print("train_df: ", len(train_df), "val_df: ", len(val_df), "test_df: ", len(test_df))

os.makedirs(f'./data/sex_banned_argument_generation/value_split', exist_ok=True)

train_df.to_csv('./data/sex_banned_argument_generation/value_split/train.csv', sep='\t', index=False)
val_df.to_csv('./data/sex_banned_argument_generation/value_split/valid.csv', sep='\t', index=False)
test_df.to_csv('./data/sex_banned_argument_generation/test.csv', sep='\t', index=False)