import numpy as np
import os
import shutil
import argparse
import _init_paths
from lib.test.evaluation.environment import env_settings


def transform_trackingnet(tracker_name, tracker_param, save_name):
    env = env_settings()
    result_dir = os.path.join(env.save_dir, tracker_name, 'test', tracker_param, save_name)
    src_dir = os.path.join(result_dir, "trackingnet/" )

    dest_dir = os.path.join(result_dir, "trackingnet_submit/")

    if not os.path.exists(dest_dir):
        os.makedirs(dest_dir)
    items = os.listdir(src_dir)
    for item in items:
        print(item,'=============================')
        #item = 'aqatrack_hivitb_v1-148'
        if "all" in item:
            continue
        if "time" not in item:
            src_path = os.path.join(src_dir, item)
            dest_path = os.path.join(dest_dir, item)
            print(src_path)
            print(dest_path)
            bbox_arr = np.loadtxt(src_path, dtype=float, delimiter='\t')
            
            bbox_arr_int = np.array(bbox_arr).astype(int)
            np.savetxt(dest_path, bbox_arr_int, fmt='%d', delimiter=',')
    
    # make zip archive
    # shutil.make_archive(src_dir, "zip", src_dir)
    shutil.make_archive(dest_dir, "zip", dest_dir)

    # Remove the original files
    # shutil.rmtree(src_dir)
    shutil.rmtree(dest_dir)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='transform trackingnet results.')
    parser.add_argument('--tracker_name', type=str, help='Name of tracking method.')
    parser.add_argument('--tracker_param', type=str, help='Name of config file.')
    parser.add_argument('--test_epoch', type=int, default=100, help='The param epoch for test.')

    args = parser.parse_args()

    save_name = 'ep{:04d}'.format(args.test_epoch)

    transform_trackingnet(args.tracker_name, args.tracker_param, save_name)
