import _init_paths
import matplotlib.pyplot as plt
plt.ion()
plt.rcParams['figure.figsize'] = [8, 8]

from lib.test.analysis.plot_results import plot_results, print_results, print_per_sequence_results
from lib.test.evaluation import get_dataset, trackerlist
import argparse

import warnings
warnings.filterwarnings("ignore")

def analysis_results(tracker_name, tracker_param, dataset_name, test_epoch):
    trackers = []
    save_name = 'ep{:04d}'.format(args.test_epoch)
    trackers.extend(trackerlist(name=tracker_name, parameter_name=tracker_param,  
                                dataset_name=dataset_name, save_name=save_name, run_ids=None))
    dataset = get_dataset(dataset_name)
    print_results(trackers, dataset, dataset_name, merge_results=True, plot_types=('success', 'norm_prec', 'prec'))

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='analysis lasot results.')
    parser.add_argument('tracker_name', type=str, help='Name of tracking method.')
    parser.add_argument('tracker_param', type=str, help='Name of config file.')
    parser.add_argument('encoder_param', type=str, help='Name of config file.')
    parser.add_argument('--dataset_name', type=str, help='Name of config file.')
    parser.add_argument('--test_epoch', type=int, default=150, help='The param epoch for test.')

    args = parser.parse_args()

    analysis_results(args.tracker_name, args.tracker_param, args.dataset_name, args.test_epoch)
