import os
import sys
from pathlib import Path
import bpy
import xml.etree.ElementTree as ET
from xml.dom import minidom

argv = sys.argv
argv = argv[argv.index("--") + 1:]

obj_id = argv[0]
obj_type = argv[1]

work_dir = Path(obj_id)
obj_path = work_dir/(obj_type+".obj")
stl_dir = work_dir/obj_type
xml_path = work_dir/(obj_type+".xml")
texture = 'green' if obj_type == 'peg' else 'red'
model_name = obj_type + obj_id
os.makedirs(stl_dir, exist_ok=True)

bpy.ops.import_scene.obj(filepath=str(obj_path))
objects = bpy.context.selected_objects

obj_xml = ET.Element("mujoco")
obj_xml.set('model', model_name)
asset = ET.SubElement(obj_xml, "asset")
meshs = []
worldbody = ET.SubElement(obj_xml, "worldbody")
ex_body = ET.SubElement(worldbody, "body")
body = ET.SubElement(ex_body, "body")
body.set('name', 'object')
geoms = []

if texture == 'red':
    mat_name = 'redwood_mat'
elif texture == 'green':
    mat_name = 'greenwood_mat'
else:
    mat_name = None

i = 0
for o in objects:
    bpy.ops.object.select_all(action="DESELECT")
    o.select_set(True)
    stl_name = str(stl_dir/(str(i)+".stl"))
    bpy.ops.export_mesh.stl(filepath=stl_name, use_selection=True)
    
    meshs.append(ET.SubElement(asset, "mesh"))
    meshs[i].set('file', str(Path(obj_type)/(str(i)+'.stl')))
    meshs[i].set('name', "mesh_"+str(i))
    
    geoms.append(ET.SubElement(body, "geom"))
    geoms[i].set('mesh', "mesh_"+str(i))
    geoms[i].set('type', 'mesh')
    geoms[i].set('group', "0")
    geoms[i].set('material', mat_name)
    
    i += 1

tex = ET.SubElement(asset, "texture")
if texture == 'red':
    tex.set('file', "../texture/red-wood.png")
    tex.set('name', "red-wood")
elif texture == 'green':
    tex.set('file', "../texture/green-wood.png")
    tex.set('name', "green-wood")

mat = ET.SubElement(asset, "material")
if texture == 'red':
    mat.set('name', "redwood_mat")
    mat.set('texture', "red-wood")
    mat.set('texrepeat', "3 3")
    mat.set('specular', "0.4")
    mat.set('shininess', "0.1")
elif texture == 'green':
    mat.set('name', "greenwood_mat")
    mat.set('texture', "green-wood")
    mat.set('texrepeat', "1 1")
    mat.set('specular', "0.4")
    mat.set("shininess", "0.1")
    
xml_str = minidom.parseString(ET.tostring(obj_xml)).toprettyxml(indent="    ")
with open(xml_path, 'w') as f:
    f.write(xml_str)
    