CUDA_VISIBLE_DEVICES=3 python train.py \
    --domain_name gym \
    --task_name Humanoid-v2 \
    --encoder_type identity \
    --replay_buffer_capacity 1000000 \
    --action_repeat 1 \
    --save_tb --pre_transform_image_size 100 --image_size 84 \
    --work_dir ./tmp/Humanoid-v2 \
    --agent crsfd_sac --frame_stack 3 \
    --seed -1 --critic_lr 1e-3 --actor_lr 1e-3 --eval_freq 10000 --batch_size 128 --num_train_steps 1000000 

#############################################################################
# evaluate
CUDA_VISIBLE_DEVICES=3 python train.py --domain_name s40_f5_done_0.9_128200  --init_steps 200 --save_model --save_tb --batch_size 128 --hole_height 0.8 --horizon 50 --control_freq 10 --evaluate_dir tmp427/jaco_dense_standerd/jaco_dense_standerd-1_2022-04-27_11_04_16 --task_name 0 --evaluate_step 94000 --observation_mode standerd --camera_id 4 --robot Jaco

# collect demo
CUDA_VISIBLE_DEVICES=3 python train.py --hole_height 0.8 --horizon 50 --control_freq 10 --demo_dir tmp_idea/others_demo0.25-0_intrinsic3/others_demo0.25-0_intrinsic3-3_2022-03-28_00_28 --task_name 3 --evaluate_step 190000 --observation_mode standerd --large_hole --sparse

# run sac
CUDA_VISIBLE_DEVICES=1 python train.py --domain_name 4sac  --init_steps 600 --save_tb --batch_size 512 --replay_buffer_capacity 100000 --num_train_steps 300000 --eval_freq 4000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode standerd --large_hole --sparse --task_name 4

# run demo_sac
CUDA_VISIBLE_DEVICES=2 python train.py --domain_name 4sacfd --init_steps 500 --batch_size 512 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8 --observation_mode standerd --sparse --reward_scale 10  --task_name 0 --save_tb

# run pixel input
CUDA_VISIBLE_DEVICES=2 python train.py --domain_name pixels_test --encoder_type pixel  --observation_mode pixel --init_steps 600 --save_model --save_tb --batch_size 128 --replay_buffer_capacity 100000 --num_train_steps 100000 --eval_freq 4000 --horizon 50 --control_freq 10 --hole_height 0.8 --large_hole False --task_name 0


# run image
CUDA_VISIBLE_DEVICES=2 python train.py --domain_name test_dense  --init_steps 600 --save_model --save_tb --batch_size 128 --replay_buffer_capacity 100000 --num_train_steps 100000 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode pixel --encoder_type pixel --large_hole --task_name 0


# run demo_sac
CUDA_VISIBLE_DEVICES=3 python train.py --domain_name 4sacfd_rs --init_steps 0 --save_tb --batch_size 1024 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode standerd --replay_buffer_capacity 200000 --num_train_steps 300000 --sparse --load_buffer demo/0/stochastic_sparse_large_standerd_20.npz --large_hole --demo_ratio 0.25 --reward_scale 10 --demo_decay  --task_name 4 --intrinsic_r

# run demo_sac 1/3 cm early stop
CUDA_VISIBLE_DEVICES=2 python train.py --domain_name 1cm --init_steps 0 --save_tb --batch_size 512 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode standerd --replay_buffer_capacity 100000 --num_train_steps 200000 --sparse3 --load_buffer demo_1cm/0/deterministic_dense_large_standerd.npz --large_hole --demo_decay --per_step_update 2  --demo_ratio 0.5 --reward_scale 20 --task_name 0 --insert_depth 0.01

# run demo_sac 0.3 cm early stop
CUDA_VISIBLE_DEVICES=2 python train.py --domain_name 03cm_small_small --init_steps 0 --save_tb --batch_size 512 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode standerd --replay_buffer_capacity 100000 --num_train_steps 100000 --sparse3 --load_buffer demo_03cm/0/deterministic_dense_small_standerd.npz --demo_decay --per_step_update 2  --demo_ratio 0.5 --reward_scale 10 --insert_depth 0.003  --task_name 0

# eef
CUDA_VISIBLE_DEVICES=3 python train.py --domain_name kp1_ori_large --init_steps 500 --batch_size 512 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8 --observation_mode eef --action_mode free --reward_scale 1 --task_name 1 --num_train_steps 200000 --large_hole

# run self_imitation sac
CUDA_VISIBLE_DEVICES=2 python train.py --domain_name sil_1024_15w20w__intrinsic --init_steps 500 --save_tb --batch_size 1024 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode standerd --replay_buffer_capacity 200000 --num_train_steps 500000 --sparse --large_hole  --per_step_update 2  --demo_ratio 0.25 --reward_scale 10 --task_name 3 --self_imitation --intrinsic_r --sil_threshold 20

# bc
CUDA_VISIBLE_DEVICES=1 python bc.py --domain_name 0bc --init_steps 0 --save_tb --batch_size 512 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode standerd --replay_buffer_capacity 30000 --num_train_steps 300000 --sparse --load_buffer demo/0/stochastic_sparse_large_standerd_20.npz --large_hole --task_name 0

# bc+sac demo
CUDA_VISIBLE_DEVICES=2 python train.py --domain_name bc_demo --init_steps 0 --save_tb --batch_size 512 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode standerd --replay_buffer_capacity 200000 --num_train_steps 300000 --sparse --load_buffer demo/0/stochastic_sparse_large_standerd_20.npz --large_hole --task_name 3 --demo_ratio 0.25 --reward_scale 10 --demo_decay --bc_lambda 1 --bc_decay 0.0001

# run self_imitation sac
CUDA_VISIBLE_DEVICES=1 python train.py --domain_name sil_intrinsic_15w --init_steps 500 --save_tb --batch_size 1024 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode standerd --replay_buffer_capacity 200000 --num_train_steps 500000 --sparse --large_hole  --per_step_update 2  --demo_ratio 0.25 --reward_scale 10 --self_imitation --sil_buffer_size 5000 --sil_threshold 600 --intrinsic_r  --task_name 3

# run demo_sac new
CUDA_VISIBLE_DEVICES=3 python train.py --domain_name demo_intrinsic_intime8 --init_steps 0 --save_tb --batch_size 512 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode standerd --replay_buffer_capacity 200000 --num_train_steps 300000 --sparse --load_buffer demo/0/stochastic_sparse_large_standerd_20.npz --large_hole --task_name 3 --demo_ratio 0.25 --reward_scale 10 --demo_decay --insert_depth 0.045 --intrinsic_r --in_time 8

# self imitation 0.3cm/1cm/3cm
CUDA_VISIBLE_DEVICES=1 python train.py --domain_name sil_without_torques --init_steps 500 --save_tb --batch_size 1024 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode without_torque --replay_buffer_capacity 200000 --num_train_steps 500000 --large_hole  --per_step_update 2  --demo_ratio 0.25 --reward_scale 10 --self_imitation --sil_threshold 20 --sparse3 --insert_depth 0.01 --horizon 50 --in_time 5 --intrinsic_r  --task_name 0

# Jaco dense reward
CUDA_VISIBLE_DEVICES=0 python train.py --domain_name panda_dense_eef2 --init_steps 600 --save_tb --batch_size 512 --replay_buffer_capacity 200000 --num_train_steps 500000 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8 --observation_mode eef --large_hole --save_model --robot Panda --task_name 0

# Jaco sac
CUDA_VISIBLE_DEVICES=2 python train.py --domain_name Panda_eef_sac_sparse  --init_steps 600 --save_tb --batch_size 512 --replay_buffer_capacity 1000000 --num_train_steps 1000000 --eval_freq 2000 --horizon 50 --control_freq 10 --observation_mode eef --large_hole --sparse --robot Panda --task_name 0

# Jaco self imitate
CUDA_VISIBLE_DEVICES=3 python train.py --domain_name Panda_without_torques_sil_intrinsic_digit4 --init_steps 500 --save_tb --batch_size 1024 --eval_freq 2000 --horizon 50 --control_freq 10 --observation_mode without_torque --replay_buffer_capacity 200000 --num_train_steps 500000 --large_hole  --per_step_update 2  --demo_ratio 0.25 --reward_scale 10 --self_imitation --sil_threshold 20 --sparse3 --insert_depth 0.01 --horizon 50 --in_time 5 --robot Panda --intrinsic_r --task_name 4
# evaluated
CUDA_VISIBLE_DEVICES=3 python train.py --domain_name s40_f5_done_0.9_128200  --init_steps 200 --save_model --save_tb --batch_size 128 --hole_height 0.8 --horizon 50 --control_freq 10 --evaluate_dir tmp429/panda_stopdemo_eefquat_intrinsic_test2/panda_stopdemo_eefquat_intrinsic_test2-0_2022-05-03_10_53_45 --task_name 0 --evaluate_step 982000 --observation_mode eef2 --camera_id 3 --robot Panda --large_hole

#collect demo
CUDA_VISIBLE_DEVICES=3 python train.py --hole_height 0.8 --horizon 50 --control_freq 10 --demo_dir experiment_results/tmp_demo/s50f10rnotdone_std_0.8_large_pre0_pi16_20/s50f10rnotdone_std_0.8_large_pre0_pi16_20-0_2022-03-09_13_47 --task_name 3 --evaluate_step 194000 --observation_mode standerd --large_hole --sparse --demo_obs eef --demo_early_stop --robot Panda

tmp427/jaco_dense_eef/jaco_dense_eef-4_2022-04-27_11_09_01 934000
experiment_results/tmp_idea/others_demo_0.25-0_intrinsic3/others_demo_0.25-0_intrinsic3-3_2022-03-26_22_27 164000
experiment_results/tmp_demo/s50f10rnotdone_std_0.8_large_pre0_pi16_20/s50f10rnotdone_std_0.8_large_pre0_pi16_20-0_2022-03-09_13_47 194000
# run demo_sac eef
CUDA_VISIBLE_DEVICES=3 python train.py --domain_name panda_stopdemo_eef_baseline --init_steps 0 --save_tb --batch_size 512 --eval_freq 2000 --horizon 50 --control_freq 10  --observation_mode eef --replay_buffer_capacity 1000000 --num_train_steps 1000000 --sparse --load_buffer demo_eef_jaco/3/panda_deterministic_sparse_large_eef_stop.npz --large_hole --demo_ratio 0.25 --reward_scale 10 --robot Panda --demo_decay --task_name 3 

# run demo_sac without_torque
CUDA_VISIBLE_DEVICES=1 python train.py --domain_name panda_demo_notorque --init_steps 0 --save_tb --batch_size 512 --eval_freq 2000 --horizon 50 --control_freq 10  --observation_mode without_torque --replay_buffer_capacity 200000 --num_train_steps 300000 --sparse --load_buffer demo_eef_jaco/3/panda_deterministic_sparse_large_without_torque_notorque.npz --large_hole --demo_ratio 0.25 --reward_scale 10 --demo_decay --robot Panda --task_name 3

# self imitation learning eef
CUDA_VISIBLE_DEVICES=2 python train.py --domain_name sil_eef --init_steps 500 --save_tb --batch_size 1024 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode eef --replay_buffer_capacity 200000 --num_train_steps 1000000 --large_hole  --per_step_update 2  --demo_ratio 0.25 --reward_scale 10 --self_imitation --sil_threshold 20 --sparse3 --insert_depth 0.01 --horizon 50 --in_time 5 --intrinsic_r --task_name 0 

# run sac
CUDA_VISIBLE_DEVICES=1 python train.py --domain_name 0sac_5mm  --init_steps 600 --save_tb --batch_size 512 --replay_buffer_capacity 300000 --num_train_steps 300000 --eval_freq 4000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode standerd --large_hole  --task_name 0 --hole_range 0.005 --sparse

# run sacfd
CUDA_VISIBLE_DEVICES=3 python train.py --domain_name 0sqil_random_4mm_0.5 --init_steps 0 --save_tb --batch_size 512 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode standerd --replay_buffer_capacity 300000 --num_train_steps 300000 --sparse --load_buffer demo/0/stochastic_sparse_large_standerd_20.npz --large_hole --demo_ratio 0.5 --reward_scale 10 --task_name 0 --hole_range 0.004 --imitation_learning --sqil
--demo_decay

# run demo_sac
CUDA_VISIBLE_DEVICES=1 python train.py --domain_name 2sacfdrs_0.5_2mm_sqil_decay_r2 --init_steps 0 --save_tb --batch_size 512 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode standerd --replay_buffer_capacity 300000 --num_train_steps 300000 --sparse --load_buffer demo/0/stochastic_sparse_large_standerd_20.npz --large_hole --demo_ratio 0.5 --reward_scale 10 --task_name 2 --hole_range 0.002 --intrinsic_r --r_lambda 2 --sqil --demo_decay

# run dense_demo_sacfd
CUDA_VISIBLE_DEVICES=3 python train.py --domain_name 0sacfdrs_dense3_4mm_0.5_decay --init_steps 0 --save_tb --batch_size 512 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode standerd --replay_buffer_capacity 300000 --num_train_steps 300000 --load_buffer demo/0/stochastic_dense_large_standerd3.npz --large_hole --demo_ratio 0.5 --reward_scale 10 --task_name 0 --hole_range 0.004 --demo_decay


# run demo_sac_sil
CUDA_VISIBLE_DEVICES=2 python train.py --domain_name demo_intrinsic_intime8 --init_steps 0 --save_tb --batch_size 512 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode standerd --replay_buffer_capacity 200000 --num_train_steps 300000 --sparse --load_buffer demo/0/stochastic_sparse_large_standerd_20.npz --large_hole --task_name 3 --demo_ratio 0.25 --reward_scale 10 --demo_decay --insert_depth 0.045  --in_time 5 --sqil

# run dense_demo_sacfd
CUDA_VISIBLE_DEVICES=2 python train.py --domain_name demo_intrinsic_intime8 --init_steps 0 --save_tb --batch_size 512 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode standerd --replay_buffer_capacity 200000 --num_train_steps 300000 --load_buffer demo/0/stochastic_dense_large_standerd.npz --large_hole --task_name 3 --demo_ratio 0.25 --reward_scale 10 --demo_decay

# self imitation 0.3cm/1cm/3cm
CUDA_VISIBLE_DEVICES=3 python train.py --domain_name 2sil_rs-3-1  --init_steps 500 --save_tb --batch_size 1024 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode standerd --replay_buffer_capacity 200000 --num_train_steps 500000 --large_hole  --per_step_update 2  --demo_ratio 0.25 --reward_scale 10 --self_imitation --sil_threshold 20 --sparse3 --insert_depth 0.01 --horizon 50 --in_time 5 --task_name 2 --intrinsic_r


# run demo_sac
CUDA_VISIBLE_DEVICES=2 python train.py --domain_name 6sacfd_rs --init_steps 0 --save_tb --batch_size 512 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode standerd --replay_buffer_capacity 300000 --num_train_steps 300000 --sparse --load_buffer demo/0/stochastic_sparse_large_standerd_20.npz --demo_ratio 0.5 --reward_scale 10 --task_name 6 --intrinsic_r --sqil --r_lambda 1

# run demo_sac
CUDA_VISIBLE_DEVICES=1 python train.py --domain_name 5sacfd --init_steps 0 --save_tb --batch_size 512 --eval_freq 2000 --horizon 50 --control_freq 10 --hole_height 0.8  --observation_mode standerd --replay_buffer_capacity 300000 --num_train_steps 300000 --sparse --load_buffer demo/0/stochastic_sparse_large_standerd_20.npz --demo_ratio 0.5 --reward_scale 10 --task_name 5