# Asymmetrically Perturbed Learning

## Normal Form Games
This code is available in [nfg](nfg/)

### Preparation
```sh
cd nfg
pip install -r requirements.txt
```

### Algorithms

#### Asymmetrically perturbed gradient descent ascent (AsymP-GDA)
AsymP-GDA introduces the concepts of asymmetric perturbation to the gradient descent-ascent algorithm. Its main features include:

- **perturbation_strength**: A parameter that controls the strength of perturbation added to the gradient
- **update_anchoring_interval**: A parameter that controls how frequently the anchoring strategy is updated

### Run Experiments
```sh
cd nfg
bash scripts/run_meq_wei.sh
bash scripts/run_biased_brps.sh
```

---

## Extensive Form Games
This code is available in [efg](efg/)

### Algorithms

#### Asymmetrically perturbed CFR+ (AsymP-CFR+)
AsymP-CFR+R introduces the concepts of Asymmetric perturbation to the CFR-based algorithm. Its main features include:

- **mutation_rate**: A parameter that controls the strength of perturbation applied during strategy updates
- **asym_player_id**: A parameter that specifies which player to apply perturbation to (applies to all players if set to -1)
- **update_anchoring_interval**: A parameter that controls how frequently the anchoring strategy is updated (no updates if set to 0)

### Preparation

```sh
cd efg
git clone https://github.com/google-deepmind/open_spiel.git
cd open_spiel && git checkout -b tag/v1.2 refs/tags/v1.2
bash install.sh
```

```sh
cd efg
# Set OpenSpiel path (run this in the parent directory of open_spiel)
export OPEN_SPIEL_PATH=${PWD}/open_spiel
```

```sh
cd efg/src
bash build.sh
```

### Run Experiments
```sh
cd efg
bash scripts/experiments.sh
```
