#ifndef MUTANT_FTRL_EFG_AVERAGE_POLICY_HPP
#define MUTANT_FTRL_EFG_AVERAGE_POLICY_HPP

#include <string>

#include "open_spiel/policy.h"
#include "open_spiel/spiel.h"
#include "open_spiel/spiel_utils.h"
#include "info_state_values.hpp"

namespace open_spiel {
namespace algorithms {

// A policy that extracts the average policy from the CFR table values, which
// can be passed to tabular exploitability.
class AveragePolicy : public Policy {
public:
    // Returns the average policy from the CFR values.
    // If a state/info state is not found, return the default policy for the
    // state/info state (or an empty policy if default_policy is nullptr).
    // If an info state has zero cumulative regret for all actions,
    // return a uniform policy.
    AveragePolicy(const InfoStateValuesTable &info_states, std::shared_ptr<Policy> default_policy);

    ActionsAndProbs GetStatePolicy(const State &state) const override {
        return GetStatePolicy(state, state.CurrentPlayer());
    };

    ActionsAndProbs GetStatePolicy(const State &state, Player player) const override;

    ActionsAndProbs GetStatePolicy(const std::string &info_state) const override;

    TabularPolicy AsTabular() const;

private:
    const InfoStateValuesTable &info_states_;
    std::shared_ptr<Policy> default_policy_;

    void GetStatePolicyFromInformationStateValues(
            const InfoStateValues &is_vals, ActionsAndProbs *actions_and_probs) const;
};

}  // namespace algorithms
}  // namespace open_spiel


#endif //MUTANT_FTRL_EFG_AVERAGE_POLICY_HPP