
#ifndef OPEN_SPIEL_ALGORITHMS_ALGORITHM_BASE_H_
#define OPEN_SPIEL_ALGORITHMS_ALGORITHM_BASE_H_

#include <memory>
#include "open_spiel/policy.h"
#include "open_spiel/spiel.h"

namespace open_spiel {
namespace algorithms {

class AlgorithmBase {
    public:
        virtual ~AlgorithmBase() = default;

        virtual void EvaluateAndUpdatePolicy() = 0;

        virtual std::string GetName() const = 0;

        virtual std::shared_ptr<Policy> AveragePolicy() const = 0;

        virtual std::shared_ptr<Policy> CurrentPolicy() const = 0;

        virtual std::shared_ptr<TabularPolicy> CurrentTabularPolicy() const = 0;
};

}  // namespace algorithms
}  // namespace open_spiel

#endif  // OPEN_SPIEL_ALGORITHMS_ALGORITHM_BASE_H_