

#ifndef OPEN_SPIEL_ALGORITHMS_DCFR_H_
#define OPEN_SPIEL_ALGORITHMS_DCFR_H_

#include <string>
#include <utility>
#include <vector>

#include "open_spiel/spiel.h"
#include "info_state_values.hpp"
#include "average_policy.hpp"
#include "current_policy.hpp"
#include "cfr.hpp"

namespace open_spiel {
namespace algorithms {

class DCFRSolver : public MyCFRSolver {
public:
    static inline const std::string alg_name = "full_dcfr";

    DCFRSolver(const Game &game, double alpha, double beta, double gamma, const bool regret_matching_plus = false)
            : MyCFRSolver(game,
                          alg_name + "/alpha_" + std::to_string(alpha) + "_beta_" + std::to_string(beta) + "_gamma_" + std::to_string(gamma), regret_matching_plus),
              alpha_(alpha),
              beta_(beta),
              gamma_(gamma)
              {}

    DCFRSolver(const Game &game, const std::string name, double alpha, double beta, double gamma, const bool regret_matching_plus = false)
            : MyCFRSolver(game, name, regret_matching_plus),
              alpha_(alpha),
              beta_(beta),
              gamma_(gamma)
              {}

    virtual ~DCFRSolver() = default;


protected:
    // for discounting
    const double alpha_;
    const double beta_;
    const double gamma_;

    void UpdateStrategy() override;
    void UpdateAveragePolicy(InfoStateValues *is_vals, const int aidx, const double value) override;
};


class LCFRSolver : public DCFRSolver {
public:
    static inline const std::string alg_name = "full_lcfr";

    LCFRSolver(const Game &game, const bool regret_matching_plus = false)
            : DCFRSolver(game,
                          alg_name,
                          1.0,
                          1.0,
                          1.0,
                          regret_matching_plus) {}

    LCFRSolver(const Game &game, const std::string name, const bool regret_matching_plus = false)
            : DCFRSolver(game,
                          std::move(name),
                          1.0,
                          1.0,
                          1.0,
                          regret_matching_plus) {}

    virtual ~LCFRSolver() = default;
};


}  // namespace algorithms
}  // namespace open_spiel

#endif  // OPEN_SPIEL_ALGORITHMS_CFRSP_H_