#ifndef MUTANT_FTRL_EFG_INFO_STATE_VALUES_HPP
#define MUTANT_FTRL_EFG_INFO_STATE_VALUES_HPP

#include <string>
#include <unordered_map>
#include <vector>

#include "open_spiel/spiel.h"
#include "open_spiel/spiel_utils.h"

namespace open_spiel {
namespace algorithms {

// A basic structure to store the relevant quantities.
struct InfoStateValues {
    InfoStateValues() {}

    InfoStateValues(int player, std::vector<Action> la, double init_value)
            : legal_actions(la),
              update_count(0),
              cfr_reach_prob(0.0),
              need_update(false),
              cumulative_regrets(la.size(), init_value),
              instant_regrets(la.size(), init_value),
              cumulative_policy(la.size(), init_value),
              current_policy(la.size(), 1.0 / la.size()),
              current_policy_hat(la.size(), 1.0 / la.size()),
              anchoring_strategy(la.size(), 1.0 / la.size()),
              player(player) {}

    InfoStateValues(int player, std::vector<Action> la) : InfoStateValues(player, la, 0) {}

    void ApplyRegretMatching(const bool regret_matching_plus = false);
    void ApplyPredictiveRegretMatching(const bool regret_matching_plus = false);
    void ApplySoftmax(const double eta);
    void ApplyKLProjection(std::vector<double> &p, std::vector<double> &q, std::vector<double> &y) const;
    void ApplyL2(const double eta);
    void ApplyL2Projection(const double eta);
    void ApplyL2Projection(std::vector<double> &p, std::vector<double> &q, std::vector<double> &y) const;

    bool empty() const { return legal_actions.empty(); }

    int num_actions() const { return legal_actions.size(); }

    // Extracts the current policy. Note: assumes it is filled.
    ActionsAndProbs GetCurrentPolicy() const;

    int player;
    int update_count;
    double cfr_reach_prob;
    bool need_update;
    std::vector<Action> legal_actions;
    std::vector<double> cumulative_regrets;
    std::vector<double> instant_regrets;
    std::vector<double> cumulative_policy;
    std::vector<double> current_policy;
    std::vector<double> current_policy_hat;
    std::vector<double> anchoring_strategy;
};

// A type for tables holding CFR values.
using InfoStateValuesTable = std::unordered_map<std::string, InfoStateValues>;

}  // namespace algorithms
}  // namespace open_spiel

#endif //MUTANT_FTRL_EFG_INFO_STATE_VALUES_HPP