#include "logger.hpp"
#include <fstream>

Logger::Logger(std::string filename, std::string header):logFile(filename)
{
    // remove filename if it exists
    std::remove(filename.c_str());
    buffer.push_back(header);
}

void Logger::log(const std::string& message)
{
    buffer.push_back(message);
}

void Logger::flush()
{
    std::ofstream outfile;
    outfile.open(logFile, std::ios_base::app);
    for(const auto& line : buffer)
    {
        outfile << line << "\n";
    }
    outfile.close();
    buffer.clear();
}



Logger::~Logger()
{
    flush();
}