#include <ctime>
#include <fstream>
#include <iostream>

#include "utils.hpp"
#include <filesystem>
std::string GetCurrentTime()
{
    std::time_t t = std::time(0);
    std::tm* now = std::localtime(&t);
    char buf[80];
    strftime(buf, sizeof(buf), "%Y-%m-%dT%H:%M:%S", now);
    return buf;
}

void MakeDir(const std::string& path)
{
    std::filesystem::path dirPath(path);
    if (!std::filesystem::exists(dirPath)) {
        std::filesystem::create_directories(dirPath);
        std::cerr << "Directory created at " << path << '\n';
    } else {
        std::cerr << "Directory already exists at " << path << '\n';
    }
}