
set -eu
games=(
    'kuhn_poker'
    'turn_based_simultaneous_game(game=goofspiel(imp_info=True,num_cards=4,points_order=descending))'
    'liars_dice(dice_sides=4)'
    'leduc_poker'
    'turn_based_simultaneous_game(game=goofspiel(imp_info=True,num_cards=5,points_order=descending))'
    'liars_dice(dice_sides=6)'
)

num_iters=100
mutation_rate=0.01
asym_player_ids=(-1 0 1)
logdir="./logs_test"
baselines=("cfr" "cfr_plus" "dcfr" "lcfr")


for game in "${games[@]}" 
do
    for baseline in "${baselines[@]}"
        do
            command="./src/build/run_full --logdir $logdir --game_name $game --alg_name $baseline --num_iters $num_iters"
            $command
        done
    for asym_player_id in "${asym_player_ids[@]}"
        do
            command="./src/build/run_full --logdir $logdir  --game_name $game --alg_name "pcfr_plus" --num_iters $num_iters --mutation_rate $mutation_rate --asym_player_id $asym_player_id"
            $command
        done
    done
done
