#ifndef MUTANT_FTRL_EFG_CURRENT_POLICY_HPP
#define MUTANT_FTRL_EFG_CURRENT_POLICY_HPP

#include <string>

#include "open_spiel/policy.h"
#include "open_spiel/spiel.h"
#include "open_spiel/spiel_utils.h"
#include "info_state_values.hpp"

namespace open_spiel {
namespace algorithms {

// A policy that extracts the current policy from the CFR table values.
class CurrentPolicy : public Policy {
public:
    // Returns the current policy from the CFR values. If a default policy is
    // passed in, then it means that it is used if the lookup fails (use nullptr
    // to not use a default policy).
    CurrentPolicy(const InfoStateValuesTable &info_states, std::shared_ptr<Policy> default_policy);

    ActionsAndProbs GetStatePolicy(const State &state) const override {
        return GetStatePolicy(state, state.CurrentPlayer());
    };

    ActionsAndProbs GetStatePolicy(const State &state, Player player) const override;

    ActionsAndProbs GetStatePolicy(const std::string &info_state) const override;

    TabularPolicy AsTabular() const;

private:
    const InfoStateValuesTable &info_states_;
    std::shared_ptr<Policy> default_policy_;

    ActionsAndProbs GetStatePolicyFromInformationStateValues(
            const InfoStateValues &is_vals, ActionsAndProbs &actions_and_probs) const;
};

}  // namespace algorithms
}  // namespace open_spiel

#endif //MUTANT_FTRL_EFG_CURRENT_POLICY_HPP