#ifndef OPEN_SPIEL_ALGORITHMS_CFR_PLUS_H_
#define OPEN_SPIEL_ALGORITHMS_CFR_PLUS_H_

#include <string>
#include <vector>

#include "open_spiel/spiel.h"
#include "regret_minimization_algorithm.hpp"

namespace open_spiel {
namespace algorithms {

class MyCFRSolver: public RegretMinimizationAlgorithm {
public:
    static inline const std::string alg_name = "full_cfr";

    MyCFRSolver(const Game &game, const bool regret_matching_plus = false);

    MyCFRSolver(const Game &game, std::string name, const bool regret_matching_plus = false);

    virtual ~MyCFRSolver() = default;

protected:
    // Update the current policy for all information states.
    void UpdateStrategy() override;
    void UpdateAveragePolicy(InfoStateValues *is_vals, const int aidx, const double value) override;
    const bool regret_matching_plus_;

};

class MyCFRPlusSolver: public MyCFRSolver {
public:
    static inline const std::string alg_name = "full_cfr_plus";

    MyCFRPlusSolver(const Game &game) : MyCFRSolver(game, alg_name, true) {}

    MyCFRPlusSolver(const Game &game, std::string name) : MyCFRSolver(game, std::move(name), true) {}

    virtual ~MyCFRPlusSolver() = default;

};

}  // namespace algorithms
}  // namespace open_spiel

#endif  // OPEN_SPIEL_ALGORITHMS_CFR_PLUS_H_