from games.matrix_game import ZeroSumMatrixGame
from runner.logger import Logger


def run(
    game,
    T,
    players,
    stop_early=False,
    print_interval=100000,
    log_interval=10000,
):
    n_players = game.num_players()
    log = Logger()
    for t in range(T):
        strategies = [player.strategy.copy() for player in players]
        gradient = game.full_feedback(strategies)
        for i in range(n_players):
            players[i].add_gradient(gradient[i])
        for player in players:
            player.calc_strategy()

        if t % print_interval == 0 or t == T - 1:
            print_info(t, game, players)

        # record log
        if t < log_interval or t % log_interval == 0 or t == T - 1:
            record_log(log, t, game, players)

    return log


def record_log(log, t, game, players):
    n_players = len(players)
    strategies = [player.strategy for player in players]
    nash_conv_last_iterate = game.nash_conv(strategies)
    individual_nash_convs = game.individual_nash_convs(strategies)
    log["t"].append(t)
    log["nash_conv_last_iterate"].append(nash_conv_last_iterate)
    for i in range(n_players):
        log["player{}_individual_nash_conv".format(i)].append(individual_nash_convs[i])


def print_info(t, game, players):
    print("---Run Iteration {}---".format(t))
    strategies = [player.strategy for player in players]
    nash_conv_last_iterate = game.nash_conv(strategies)
    individual_nash_convs = game.individual_nash_convs(strategies)
    print("Nash conv of last-iterate strategies : {}".format(nash_conv_last_iterate))
    print("Individual Nash convs: {}".format(individual_nash_convs))
    print(strategies)
