# A Spectral Framework for Evaluating Geodesic Distances Between Graphs
## Run the following notebooks to prepare the environment:

Sets up the necessary output directories:
```output_folder_setup.ipynb
```
Coarsens TU datasets and stores graphs:
```coarsening/coarsening_tudataset_with_node_features.ipynb
```

To use a different TU dataset:
Download from TU Datasets (https://chrsmrrs.github.io/datasets/docs/datasets/), Unzip and place it in the ``coarsening/data`` directory.

## GGD Computation
### To compute the GGD between two graphs:
```calculate_ggd.ipynb
```

### To compute all pairwise GGD values in a dataset:
```calculate_all_ggd.ipynb
```

## Classification and Evaluation
### To run the classifier:
```classifier.ipynb
```

### To test the stability of Graph Isomorphism Networks (GIN):
```stability.ipynb
```

### To compute distances between datasets:
```GGD_datasets.ipynb
```