# -*- coding: utf-8 -*-
"""
Created on Wed May  3 22:07:56 2023

@author: pnzha
"""

import numpy as np
import pandas as pd
from RegressionModels import HuberRegression, MoMRegression, KernelRegression, projection
from tqdm import tqdm

def Kernel(u):
    return 2 - abs(u)

Ntrain = 10000
M = 1000
Xeval = np.linspace(0,1,51).reshape(-1,1)
eta = np.sin(2*np.pi*Xeval.ravel())

n = 11
e_kernel = np.zeros((n, M))
e_mom = np.zeros((n,M))
e_initial = np.zeros((n, M))
e_corrected = np.zeros((n, M))
e_sup_kernel = np.zeros((n, M))
e_sup_mom = np.zeros((n,M))
e_sup_initial = np.zeros((n, M))
e_sup_corrected = np.zeros((n, M))
qlist = np.zeros(n)

attack_model = 'random'

for i in range(n):
    q = 500 * i
    qlist[i] = q
    for t in tqdm(range(M)):
        X = np.random.uniform(0,1,(Ntrain,1))
        y = np.sin(2*np.pi*X.ravel()) + np.random.normal(0,1,Ntrain)
        if attack_model == 'random':
            attack_indices = np.random.choice(np.arange(Ntrain), q, replace = False)
            y[attack_indices] = np.random.choice([-10,10], q)
        elif attack_model == 'onedirection':
            attack_indices = np.random.choice(np.arange(Ntrain), q, replace = False)
            y[attack_indices] = 10
        elif attack_model == 'centralized':
            attack1_indices = sorted(range(Ntrain), key = \
                                     lambda k: abs(X.ravel()[k] - 0.25))[:q//2]
            y[attack1_indices] = 10
            attack2_indices = sorted(range(Ntrain), key = \
                                     lambda k: abs(X.ravel()[k] - 0.75))[:q//2]
            y[attack2_indices] = -10
        
        SimpleKernel = KernelRegression(0.03, Kernel, 3)
        SimpleKernel.fit(X, y)
        y_kernel = SimpleKernel.predict(Xeval)
        e_kernel[i,t] = np.mean((y_kernel - eta) ** 2)
        e_sup_kernel[i,t] = np.max(np.abs(y_kernel - eta))
        
        MoM = MoMRegression(0.03, Kernel, 3, 20)
        MoM.fit(X, y)
        y_mom = MoM.predict(Xeval)
        e_mom[i,t] = np.mean((y_mom - eta) ** 2)
        e_sup_mom[i,t] = np.max(np.abs(y_mom - eta))
        
        Initial = HuberRegression(0.03, Kernel, 1, 3)
        Initial.fit(X, y)
        y_initial = Initial.predict(Xeval)
        e_initial[i,t] = np.mean((y_initial - eta) ** 2)
        e_sup_initial[i,t] = np.max(np.abs(y_initial - eta))
        
        y_corrected = projection(y_initial, 0.13)
        e_corrected[i,t] = np.mean((y_corrected - eta) ** 2)
        e_sup_corrected[i,t] = np.max(np.abs(y_corrected - eta))
    print("q: {}".format(q))
    print("L2 error: kernel: {:.5f}, MoM: {:.5f}, initial: {:.5f}, corrected: {:.5f}".format\
          (np.mean(e_kernel[i]), np.mean(e_mom[i]), np.mean(e_initial[i]), np.mean(e_corrected[i])))
    print("sup error: kernel: {:.5f}, MoM: {:.5f}, initial: {:.5f}, corrected: {:.5f}".format\
          (np.mean(e_sup_kernel[i]), np.mean(e_sup_mom[i]), np.mean(e_sup_initial[i]), np.mean(e_sup_corrected[i])))

output = pd.DataFrame({"q": qlist, "kernel": np.mean(e_kernel, axis = 1), \
          "MoM": np.mean(e_mom, axis = 1), \
              "initial": np.mean(e_initial, axis = 1),\
              "corrected": np.mean(e_corrected, axis = 1)})
output.to_csv("{}_data.csv".format(attack_model), index = None)

output_sup = pd.DataFrame({"q": qlist, "kernel": np.mean(e_sup_kernel, axis = 1), \
          "MoM": np.mean(e_sup_mom, axis = 1), \
              "initial": np.mean(e_sup_initial, axis = 1), \
              "corrected": np.mean(e_sup_corrected, axis = 1)})
output_sup.to_csv("{}_data_sup.csv".format(attack_model), index = None)
    
