# -*- coding: utf-8 -*-
"""
Created on Mon May  8 17:07:19 2023

@author: ZJ
"""

import numpy as np
import pandas as pd
from RegressionModels import HuberRegression, KernelRegression, MoMRegression, projection2d
from tqdm import tqdm
from itertools import product
from sklearn.neighbors import NearestNeighbors

def Kernel(u):
    return 2 - abs(u)

Ntrain = 10000
M = 1000
Lgrid = 21
Xgrid = np.linspace(0,1,Lgrid)
Xeval = np.array(list(product(Xgrid, Xgrid)))
eta = np.sin(2*np.pi*Xeval[:,0]) + np.cos(2*np.pi*Xeval[:,1])

n = 11
e_kernel = np.zeros((n, M))
e_mom = np.zeros((n,M))
e_initial = np.zeros((n, M))
e_corrected = np.zeros((n, M))
e_sup_kernel = np.zeros((n, M))
e_sup_mom = np.zeros((n,M))
e_sup_initial = np.zeros((n, M))
e_sup_corrected = np.zeros((n, M))
qlist = np.zeros(n)

h = 0.1 #kernel bandwidth

attack_model = 'onedirection'

for i in range(n):
    #q = 500 * i
    q = 500 * i
    qlist[i] = q
    for t in tqdm(range(M)):
        X = np.random.uniform(0,1,(Ntrain,2))
        y = np.sin(2*np.pi*X[:,0]) + np.cos(2*np.pi*X[:,1]) + np.random.normal(0,1,Ntrain)
        if attack_model == 'random':
            attack_indices = np.random.choice(np.arange(Ntrain), q, replace = False)
            y[attack_indices] = np.random.choice([-10,10], q)
        elif attack_model == 'onedirection':
            attack_indices = np.random.choice(np.arange(Ntrain), q, replace = False)
            y[attack_indices] = 10
        elif attack_model == 'centralized':
            if q>0:
                attack_centers = np.random.uniform(0,1, (2, 2))
                nb = NearestNeighbors(n_neighbors = q//2)
                nb.fit(X)
                attack1_indices, attack2_indices = \
                    nb.kneighbors(attack_centers, return_distance = False)
                y[attack1_indices] = 10
                y[attack2_indices] = -10
        
        SimpleKernel = KernelRegression(h, Kernel, 3)
        SimpleKernel.fit(X, y)
        y_kernel = SimpleKernel.predict(Xeval)
        e_kernel[i,t] = np.mean((y_kernel - eta) ** 2)
        e_sup_kernel[i,t] = np.max(np.abs(y_kernel - eta))

        MoM = MoMRegression(h, Kernel, 3, 5)
        MoM.fit(X, y)
        y_mom = MoM.predict(Xeval)
        e_mom[i,t] = np.mean((y_mom - eta) ** 2)
        e_sup_mom[i,t] = np.max(np.abs(y_mom - eta))
        
        Initial = HuberRegression(h, Kernel, 1, 3)
        Initial.fit(X, y)
        y_initial = Initial.predict(Xeval)
        e_initial[i,t] = np.mean((y_initial - eta) ** 2)
        e_sup_initial[i,t] = np.max(np.abs(y_initial - eta))
        
        y_initial_2d = y_initial.reshape((Lgrid, Lgrid))
        y_corrected = projection2d(y_initial_2d, 0.32).ravel()
        e_corrected[i,t] = np.mean((y_corrected - eta) ** 2)
        e_sup_corrected[i,t] = np.max(np.abs(y_corrected - eta))
    print("q: {}".format(q))
    print("L2 error: kernel: {:.5f}, MoM: {:.5f}, initial: {:.5f}, corrected: {:.5f}".format\
          (np.mean(e_kernel[i]), np.mean(e_mom[i]), np.mean(e_initial[i]), np.mean(e_corrected[i])))
    print("sup error: kernel: {:.5f}, MoM: {:.5f}, initial: {:.5f}, corrected: {:.5f}".format\
          (np.mean(e_sup_kernel[i]), np.mean(e_sup_mom[i]), np.mean(e_sup_initial[i]), np.mean(e_sup_corrected[i])))

output = pd.DataFrame({"q": qlist, "kernel": np.mean(e_kernel, axis = 1), \
          "MoM": np.mean(e_mom, axis = 1), \
              "initial": np.mean(e_initial, axis = 1),\
              "corrected": np.mean(e_corrected, axis = 1)})
output.to_csv("{}_data2d.csv".format(attack_model), index = None)

output_sup = pd.DataFrame({"q": qlist, "kernel": np.mean(e_sup_kernel, axis = 1), \
          "MoM": np.mean(e_sup_mom, axis = 1), \
              "initial": np.mean(e_sup_initial, axis = 1), \
              "corrected": np.mean(e_sup_corrected, axis = 1)})
output_sup.to_csv("{}_data_sup2d.csv".format(attack_model), index = None)
