# -*- coding: utf-8 -*-
"""
Created on Thu May  4 19:16:56 2023

@author: ZJ
"""

import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
plt.rcParams.update({'font.size': 15})

attack_model = 'onedirection'
dim = 2

plt.figure(figsize = (6,6))
if dim == 2:
    d = pd.read_csv('{}_data2d.csv'.format(attack_model))
else:
    d = pd.read_csv('{}_data.csv'.format(attack_model))
plt.plot(d['q'], np.sqrt(d['kernel']), ':', linewidth = 2)
plt.plot(d['q'], np.sqrt(d['MoM']), '-.', linewidth = 2)
plt.plot(d['q'], np.sqrt(d['initial']), '--', linewidth = 2)
plt.plot(d['q'], np.sqrt(d['corrected']), linewidth = 2)
plt.legend(['kernel', 'MoM', 'initial', 'corrected'])
plt.xlabel('q')
plt.ylabel('Root MSE')
if dim == 2:
    plt.savefig('{}_rmse2d.pdf'.format(attack_model),bbox_inches='tight')
else:
    plt.savefig('{}_rmse.pdf'.format(attack_model),bbox_inches='tight')
    
plt.figure(figsize=(6,6))
if dim == 2:
    dsup = pd.read_csv('{}_data_sup2d.csv'.format(attack_model))
else:
    dsup = pd.read_csv('{}_data_sup.csv'.format(attack_model))
plt.plot(dsup['q'], dsup['kernel'], ':', linewidth = 2)
plt.plot(dsup['q'], dsup['MoM'], '-.', linewidth = 2)
plt.plot(dsup['q'], dsup['initial'], '--', linewidth = 2)
plt.plot(dsup['q'], dsup['corrected'], linewidth = 2)
plt.legend(['kernel', 'MoM', 'initial', 'corrected'])
plt.xlabel('q')
plt.ylabel('Supremum Error')
if dim == 2:
    plt.savefig('{}_sup2d.pdf'.format(attack_model),bbox_inches='tight')
else:
    plt.savefig('{}_sup.pdf'.format(attack_model),bbox_inches='tight')