# -*- coding: utf-8 -*-
"""
Created on Mon May  8 14:46:45 2023

@author: ZJ
"""

import numpy as np
from RegressionModels import HuberRegression, KernelRegression, projection
import matplotlib.pyplot as plt

def Kernel(u):
    return 2 - abs(u)

Ntrain = 10000
X = np.random.uniform(0,1,(Ntrain,1))
y = np.sin(2*np.pi*X.ravel()) + np.random.normal(0,1,Ntrain)

plt.rcParams.update({'font.size': 13})

#Set evaluation grids
Xeval = np.linspace(0,1,101).reshape(-1,1)

#Ground truth
eta = np.sin(2*np.pi*Xeval.ravel())

#Centralized attack
q = 2000
attack1_indices = sorted(range(Ntrain), key = \
                             lambda k: abs(X.ravel()[k] - 0.25))[:q//2]
y[attack1_indices] = np.random.normal(10,1,len(attack1_indices))
attack2_indices = sorted(range(Ntrain), key = \
                             lambda k: abs(X.ravel()[k] - 0.75))[:q//2]
y[attack2_indices] = -np.random.normal(10,1,len(attack1_indices))

SimpleKernel = KernelRegression(0.05, Kernel, 3)
SimpleKernel.fit(X, y)
Initial = HuberRegression(0.05, Kernel, 1, 3)
Initial.fit(X, y)
y_kernel = SimpleKernel.predict(Xeval)
y_initial = Initial.predict(Xeval)
y_corrected = projection(y_initial, 0.07)
plt.figure()
plt.plot(Xeval, eta, '--', linewidth = 2)
plt.plot(Xeval, y_kernel, '-.', linewidth = 2)
plt.plot(Xeval, y_initial, ':', linewidth = 2)
plt.plot(Xeval, y_corrected, linewidth = 2)
plt.legend(['Ground truth', 'Kernel regression', 'Initial estimate', 'Corrected estimate'])
plt.savefig('compare_{}.pdf'.format(q))

marker_size = 2
plt.figure()
plt.scatter(X,y,marker = '.', s = marker_size)
plt.scatter(X[attack1_indices], y[attack1_indices], marker='.', c='r',s = marker_size)
plt.scatter(X[attack2_indices], y[attack2_indices], marker='.', c='r',s = marker_size)
plt.legend(['Normal samples', 'attacked samples'], markerscale = 10)
plt.savefig('samples_{}.pdf'.format(q))


