import numpy as np


class AverageMeter:
    def __init__(self):
        self._records = []

    def update(self, result):
        if isinstance(result, (list, tuple)):
            self._records += result
        else:
            self._records.append(result)

    def reset(self):
        self._records.clear()

    def records(self, last_n = None):
        if last_n is not None:
            return self._records[-last_n :]
        else:
            return self._records

    def sum(self, last_n = None):
        return np.sum(self.records(last_n))

    def mean(self, last_n = None):
        return np.mean(self.records(last_n))

    def std(self, last_n = None):
        return np.std(self.records(last_n))

    def median(self, last_n = None):
        return np.median(self.records(last_n))
