from setuptools import setup
from torch.utils.cpp_extension import BuildExtension, CUDAExtension


setup(
    name='dinoreg',
    version='1.0.0',
    ext_modules=[
        CUDAExtension(
            name='dinoreg.ext',
            sources=[
                'dinoreg/extensions/extra/cloud/cloud.cpp',
                'dinoreg/extensions/cpu/grid_subsampling/grid_subsampling.cpp',
                'dinoreg/extensions/cpu/grid_subsampling/grid_subsampling_cpu.cpp',
                'dinoreg/extensions/cpu/radius_neighbors/radius_neighbors.cpp',
                'dinoreg/extensions/cpu/radius_neighbors/radius_neighbors_cpu.cpp',
                'dinoreg/extensions/pybind.cpp',
            ],
        ),
    ],
    cmdclass={'build_ext': BuildExtension},
)
