# Data Augmentation for Imitation Learning: Learning to Branch with Hybrid Reinforcement Learning


# Getting started

Set-up your Python dependencies by editing the following files
```
conda.yaml
init.sh
```

Install the `ml4co` conda environment by running
```bash
source init.sh
```


# Generate test data

Because authors may submit up to 50MB of supplementary material, We only submitted the data corresponding to the problems of cauctions and indset problem

and other problem's data you can adjust the parameters (problem name and problem difficulty) to generate problems that cannot be typed
```
python gen_problem_lp.py # 'setcover', 'indset', 'cauctions', facilities
# function: cauctions_ablation: test the ablation study in cauctions problem
# item_placement_ablation: test the ablation study for item placement problem
```

For test data of balanced item placement, please refer to https://github.com/ds4dm/ml4co-competition


# Project structure

-MLSolver_KIDA.py: Main function for testing the effect of the KIDA model

-MLSolver_GCNN.py: Main function for testing the effect of the GCNN model

-MLSolver_HRLAug.py: Main function for testing the effect of the HRLAug model

-rewards.py: The reward calculation function for each branch

-environments.py: The settings of the test environment in the branch scenario, including whether to turn on heuristics and restart

-scip_test.py: Test the effect of scip

-gurobi_test.py: Test the effect of gurobi

-agent:

--dual_HRLAug.py: The branch strategy function corresponding to HRLAug

--dual_GCNN.py：The branch strategy function corresponding to GCNN

--dual_KIDA.py：The branch strategy function corresponding to KIDA

--agent_model.py：The model structure for HRLAug, GCNN, KIDA

--model: A collection of trained models


# Evaluate agent
* binary integer programming problem test:
```
python experiment_main.py
# problem name: 'setcover', 'indset', 'cauctions', 'facilities', 'item_placement'
# difficulty: 'easy','medium','hard'
# lp_path: location of test data
```

* test the GUROBI in item placement
```
python gurobi_test.py
```

You can adjust the input parameters to determine the problem of the test

# ATTENSION

Pay attention to modify the path of the test data when testing