from MLSolver_HRLAug import HRLAug_Main
from MLSolver_GCNN import GCNN_Main
from MLSolver_KIDA import KIDA_Main
from MLSolver_KIDAMLP import KIDAMLP_Main
from MLSolver_HRLAugMLP import HRLAugMLP_Main
from scip_test import scip_main
from MLSolver_SCIPdefault import SCIPdefault_Main
import pathlib


def main():
    # problem name:
    problem = 'cauctions'
    difficulty = 'easy'
    lp_path = "../instances/"+problem+"/test_"+difficulty + "/"
    if problem == 'item_placement':
        time_limit = 900
    else:
        time_limit = 3600
    argtask = 'dual'

    # collect the instance files
    if problem == 'item_placement':
        instances_path = pathlib.Path(lp_path)

    elif problem == 'cauctions':
        instances_path = pathlib.Path(lp_path)

    elif problem == 'indset':
        instances_path = pathlib.Path(lp_path)

    elif problem == 'setcover':
        instances_path = pathlib.Path(lp_path)

    elif problem == 'facilities':
        instances_path = pathlib.Path(lp_path)

    print(f"Processing instances from {instances_path.resolve()}")
    if problem == 'item_placement':
        instance_files = [test for test in list(instances_path.glob('*.mps.gz'))] # lp
    else:
        instance_files = [test for test in list(instances_path.glob('*.lp'))] # lp

    seed_list = [0,1,2,3,4]
    # model transfer, including MLP,RNN,CNN and so on.
    model_transfer = False
    if model_transfer:
        for tmp_instance in instance_files:
            for seed in seed_list:
                KIDAMLP_Main(problem, difficulty, lp_path, time_limit, tmp_instance, seed)
                HRLAugMLP_Main(problem, difficulty, lp_path, time_limit, tmp_instance, seed)
                scip_main(problem, difficulty, lp_path, time_limit,tmp_instance,seed,method='scip_default')
    else:
        for tmp_instance in instance_files:
            for seed in seed_list:
                GCNN_Main(problem, difficulty, lp_path, time_limit,tmp_instance,seed)
                KIDA_Main(problem, difficulty, lp_path, time_limit,tmp_instance,seed)
                HRLAug_Main(problem, difficulty, lp_path,time_limit,tmp_instance,seed)
                SCIPdefault_Main(problem, difficulty, lp_path,time_limit,tmp_instance,seed)

    return 0


if __name__ == '__main__':
    main()