from MLSolver_HRLAug import HRLAug_Main
from scip_test import scip_main
from MLSolver_retrorl import retrorl_Main
from MLSolver_rl2branch import rl2branch_Main
import pathlib


def main():
    # problem name:
    problem = 'setcover'
    difficulty = 'easy'
    lp_path = "../instances/"+problem+"/test_"+difficulty + "/"

    time_limit = 3600
    argtask = 'dual'

    # collect the instance files
    if problem == 'setcover':
        instances_path = pathlib.Path(lp_path)
    else:
        raise ValueError("only support the setcover problem for RL compare")

    print(f"Processing instances from {instances_path.resolve()}")
    if problem == 'item_placement':
        instance_files = [test for test in list(instances_path.glob('*.mps.gz'))] # lp
    else:
        instance_files = [test for test in list(instances_path.glob('*.lp'))] # lp

    seed_list = [0,1,2,3,4]
    # model transfer, including MLP and so on.

    for tmp_instance in instance_files:
        for seed in seed_list:
            HRLAug_Main(problem, difficulty, lp_path,time_limit,tmp_instance,seed)
            scip_main(problem, difficulty, lp_path, time_limit,tmp_instance,seed,method='scip_default')
            rl2branch_Main(problem, difficulty, lp_path,time_limit,tmp_instance,seed)
            retrorl_Main(problem, difficulty, lp_path,time_limit,tmp_instance,seed)
    return 0


if __name__ == '__main__':
    main()