# Towards Imitation Learning to Branch for Solving MIP: A Hybrid Reinforcement Learning based Training Sample Augmentation Approach


# Getting started

Set-up your Python dependencies by editing the following files
```
conda.yaml
init.sh
```

Install the `ml4co` conda environment by running
```bash
source init.sh
```


# Generate test data
You can adjust the parameters (problem name and problem difficulty) to generate problems that cannot be typed
```
python gen_problem_lp.py
# problem name: 'setcover', 'indset', 'cauctions', facilities
# difficulty: 'easy','medium','hard'
# test_numver: Number of test data sets
```

For test data of balanced item placement, please refer to https://github.com/ds4dm/ml4co-competition


# Project structure

-MLSolver_KIDA.py: Main function for testing the effect of the KIDA model

-MLSolver_HRLAug.py: Main function for testing the effect of the HRLAug model

-MLSolver_OfflineRL.py: Main function for testing the effect of the OfflineRL model

-MLSolver_OnlineRL.py: Main function for testing the effect of the OnlineRL model

-rewards.py: The reward calculation function for each branch

-environments.py: The settings of the test environment in the branch scenario, including whether to turn on heuristics and restart

-agent:

--dual_HRLAug.py: The branch strategy function corresponding to HRLAug

--dual_KIDA.py：The branch strategy function corresponding to KIDA

--dual_OfflineRL.py：The branch strategy function corresponding to OfflineRL

--dual_OnLineRL.py: The branch strategy function corresponding to OnlineRL

--agent_model.py：The model structure for HRLAug, KIDA

--model: A collection of trained models


# Evaluate agent
```
python experiment_main.py
# cauctions_ablation: test the ablation study in cauctions problem
# item_placement_ablation: test the ablation study for item placement problem
```

You can adjust the input parameters to determine the problem of the test

# ATTENSION
Pay attention to modify the path of the test data when testing