"""
==============
Distributions
==============

"""
import torch
from torch import nn
import torch.nn.functional as F

from _utils import *


# Prior Distributions
#=====================

class PositionFeaturePrior(torch.nn.Module):
    def __init__(self, n_dim, in_node_nf):
        super().__init__()
        self.n_dim = n_dim
        self.in_node_nf = in_node_nf

    def forward(self, z_x, z_h, batch):

        log_pz_x = center_gravity_zero_gaussian_log_likelihood_tobatch(z_x, batch)

        log_pz_h = standard_gaussian_log_likelihood_tobatch(z_h, batch)

        log_pz = log_pz_x + log_pz_h
        return log_pz

    def sample(self, n_samples, n_nodes, device):
        z_x = sample_center_gravity_zero_gaussian(size=(n_samples, n_nodes, self.n_dim), device=device)
        z_h = sample_gaussian(size=(n_samples, n_nodes, self.in_node_nf), device=device)

        return z_x, z_h


class PositionPrior(torch.nn.Module):
    def __init__(self):
        super().__init__()

    def forward(self, x):
        return center_gravity_zero_gaussian_log_likelihood(x)

    def sample(self, size, device):
        samples = sample_center_gravity_zero_gaussian(size, device)
        return samples