# POLAR Example: Simplified Layer-wise Backdoor Attack in Federated Learning

This is a minimal working example of **POLAR** — a policy-based, layer-wise backdoor attack method tailored for Federated Learning (FL).  
The script simulates an attacker injecting a trigger into CIFAR-10 image inputs and selectively modifying model layers to improve stealth and effectiveness.

---

## Files

- `example_polar.py`: Main example script that performs:
  - Benign pretraining of a simple ResNet.
  - Layer-wise perturbation using Bernoulli-sampled mask.
  - Trigger injection on test samples.
  - Evaluation of **Clean Accuracy** and **Backdoor Success Rate (BSR)**.

---

## Requirements

Install required Python libraries:

```bash
pip install torch torchvision

## Quick Start

'''python example_polar.py'''
