import random
import numpy as np
import torch
import os
import copy
from wgan_gp.utils.config import parse_args
from wgan_gp.utils.data_loader import get_data_loader
from wgan_gp.models.wgan_gradient_penalty import WGAN_GP


def main(args):
    model = WGAN_GP(args)

    # Load datasets to train and test loaders
    train_loader, _ = get_data_loader(args)  # We're not using test_loader in this function
    Real_Inception_score = []
    print(args.dataset)
    # Start model training
    model.train(train_loader, Real_Inception_score, args)


if __name__ == '__main__':
    random.seed(8)
    np.random.seed(8)
    torch.manual_seed(8)
    # os.environ["CUDA_VISIBLE_DEVICES"] = '6'

    # Define a list of values for each hyperparameter
    lr_values = [0.005]
    datasets = ['cifar10']
    optim_name = 'AdaFM'
    base_args = parse_args()
    for dataset in datasets:
        for lr in lr_values:  # Only one loop for lr
            args = copy.copy(base_args)
            args.lr_x = lr
            args.lr_y = lr  # lr_x is equal to lr_y
            args.dataset = dataset
            args.generator_iters = 20000
            # Run the main function with the current hyperparameter combination
            main(args)
