# Topological Point Features 🪴

This is the python package for topological point features (TOPF), enabling the construction of point-level features in point clouds stemming from algebraic topology and differential geometry as described in Node-Level Topological Representation Learning on Point Clouds.

![Example of TOPF on three point clouds](examples/teaserfigure.png?raw=True)

## Installation

Although being a python package, TOPF requires an installation [Julia](https://julialang.org/downloads/) because it uses the wonderful package [`Ripserer.jl`](https://mtsch.github.io/Ripserer.jl/dev/). After having installed Julia and set up PATH variables, you can build TOPF and install TOPF simply by running

    pip install build
    python -m build
    pip install dist/topf-1.0.3.tar.gz

Alternatively, you can just include the relevant .py files.

TOPF currently works under `macOS` and `Linux`. `Windows` is not supported.

## Usage

Two Jupyter-Notebooks with example usage of TOPF with [basic examples](examples/topf_basic_examples.ipynb) and [3d examples](examples/topf_examples3d.ipynb) can be found in the examples folder.

## Citation

TOPF is based on the paper 'Node-Level Topological Representation Learning on Point Clouds', under review at ICLR 2025.

## Dependencies

TOPF depends on [`Julia`](https://julialang.org), the Julia package [`Ripserer.jl`](https://mtsch.github.io/Ripserer.jl/dev/), [`Python`](https://www.python.org) and the Python packages [`numpy`](https://numpy.org), [`gudhi`](https://gudhi.inria.fr), [`matplotlib`](https://matplotlib.org), [`scikit-learn`](https://scikit-learn.org/stable/), [`scipy`](https://scipy.org), [`pandas`](https://pandas.pydata.org), and [`plotly`](https://plotly.com). The idea of how to fix Z/3Z cycles with faulty lifts to real coefficients was inspired by [DreiMac](https://dreimac.scikit-tda.org/en/latest/)'s solution to the problem (for cocycles).

## Feedback

We are happy about any feedback in the reviews! :)