/*
 * SpdzWiseInput.h
 *
 */

#ifndef PROTOCOLS_SPDZWISEINPUT_H_
#define PROTOCOLS_SPDZWISEINPUT_H_

#include "ReplicatedInput.h"

template<class T>
class SpdzWiseInput : public InputBase<T>
{
    Player& P;

    typename T::part_type::Input part_input;
    typename T::part_type::Honest::Protocol honest_mult;

    typename T::Protocol checker;
    SubProcessor<T>* proc;

    typename T::mac_key_type mac_key;

    vector<int> counters;
    vector<PointerVector<T>> shares;

public:
    SpdzWiseInput(SubProcessor<T>& proc, Player& P);
    SpdzWiseInput(SubProcessor<T>* proc, Player& P);
    SpdzWiseInput(SubProcessor<T>& proc, typename T::MAC_Check& MC);
    ~SpdzWiseInput();

    void reset(int player);
    void add_mine(const typename T::open_type& input, int n_bits = -1);
    void add_other(int player);
    void send_mine();
    void exchange();
    T finalize(int player, int n_bits = -1);
    T finalize_mine();
    void finalize_other(int player, T& target, octetStream& o, int n_bits = -1);

    void start(int, int) { throw not_implemented(); }
    void stop(int, const vector<int>&) { throw not_implemented(); }
};

#endif /* PROTOCOLS_SPDZWISEINPUT_H_ */
