from collections import defaultdict

REG_MAX = 2 ** 32
USER_MEM = 8192

P_VALUES = { 32: 2147565569, \
             64: 9223372036855103489, \
             128: 170141183460469231731687303715885907969, \
             192: 3138550867693340381917894711603833208051177722232017256453, \
             256: 57896044618658097711785492504343953926634992332820282019728792003956566065153, \
             512: 6703903964971298549787012499102923063739682910296196688861780721860882015036773488400937149083451713845015929093243025426876941405973284973216824503566337 }

P_VALUES[-1] = P_VALUES[128]

BIT_LENGTHS = { -1: 64,
                32: 16,
                64: 16,
                128: 64,
                256: 64,
                512: 64 }


COST = defaultdict(lambda: defaultdict(lambda: 0),
        { 'modp': defaultdict(lambda: 0,
         { 'triple': 0.00020652622883106154,
           'square': 0.00020652622883106154,
           'bit': 0.00020652622883106154,
           'inverse': 0.00020652622883106154,
           'PreMulC': 2 * 0.00020652622883106154,
         }),
         'gf2n': defaultdict(lambda: 0,
         { 'triple': 0.00020716801325875284,
           'square': 0.00020716801325875284,
           'inverse': 0.00020716801325875284,
           'bit': 1.4492753623188405e-07,
           'bittriple': 0.00004828818388140422,
           'bitgf2ntriple': 0.00020716801325875284,
           'PreMulC': 2 * 0.00020716801325875284,
         }),
         'all': { 'round': 0,
                  'inv': 0,
         }
})


try:
    from config_mine import *
except:
    pass
